/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.bridge.placeholder;

import com.eternalcode.combat.config.implementation.PlaceholderSettings;
import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.fight.FightManager;
import com.eternalcode.combat.fight.FightTag;
import com.eternalcode.combat.libs.com.eternalcode.commons.time.DurationParser;
import com.eternalcode.combat.util.DurationUtil;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FightTagPlaceholder
extends PlaceholderExpansion {
    private static final String IDENTIFIER = "eternalcombat";
    private final PlaceholderSettings placeholderSettings;
    private final FightManager fightManager;
    private final Server server;
    private final Plugin plugin;

    public FightTagPlaceholder(PluginConfig pluginConfig, FightManager fightManager, Server server, Plugin plugin) {
        this.placeholderSettings = pluginConfig.placeholders;
        this.fightManager = fightManager;
        this.server = server;
        this.plugin = plugin;
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        return switch (identifier) {
            case "remaining_millis" -> this.handleRemainingMillis(player);
            case "remaining_seconds" -> this.handleRemainingSeconds(player);
            case "opponent" -> this.handleOpponent(player);
            case "opponent_health" -> this.handleOpponentHealth(player);
            case "isInCombat" -> this.handleIsInCombat(player);
            case "isInCombat_formatted" -> this.handleIsInCombatFormatted(player);
            default -> null;
        };
    }

    private String handleRemainingMillis(OfflinePlayer player) {
        return this.getFightTag(player).map(tag -> DurationParser.TIME_UNITS.format(tag.getRemainingDuration())).orElse("");
    }

    private String handleRemainingSeconds(OfflinePlayer player) {
        return this.getFightTag(player).map(tag -> DurationUtil.format(tag.getRemainingDuration())).orElse("");
    }

    private String handleOpponent(OfflinePlayer player) {
        return this.getTagger(player).map(OfflinePlayer::getName).orElse("");
    }

    private String handleOpponentHealth(OfflinePlayer player) {
        return this.getTagger(player).map(tagger -> String.format("%.2f", tagger.getHealth())).orElse("");
    }

    private String handleIsInCombat(OfflinePlayer player) {
        return String.valueOf(this.isPlayerInCombat(player));
    }

    private String handleIsInCombatFormatted(OfflinePlayer player) {
        return this.isPlayerInCombat(player) ? this.placeholderSettings.isInCombatFormattedTrue : this.placeholderSettings.isInCombatFormattedFalse;
    }

    private boolean isPlayerInCombat(OfflinePlayer player) {
        Player onlinePlayer = player.getPlayer();
        return onlinePlayer != null && this.fightManager.isInCombat(onlinePlayer.getUniqueId());
    }

    @NotNull
    private Optional<Player> getTagger(OfflinePlayer player) {
        return this.getFightTag(player).map(FightTag::getTagger).map(arg_0 -> ((Server)this.server).getPlayer(arg_0));
    }

    private Optional<FightTag> getFightTag(OfflinePlayer player) {
        Player onlinePlayer = player.getPlayer();
        if (onlinePlayer == null || !this.fightManager.isInCombat(onlinePlayer.getUniqueId())) {
            return Optional.empty();
        }
        return Optional.of(this.fightManager.getTag(onlinePlayer.getUniqueId()));
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @NotNull
    public String getAuthor() {
        return (String)this.plugin.getDescription().getAuthors().get(0);
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

