/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border;

import com.eternalcode.combat.border.BorderService;
import com.eternalcode.combat.border.BorderSettings;
import com.eternalcode.combat.fight.FightManager;
import com.eternalcode.combat.fight.event.FightTagEvent;
import com.eternalcode.combat.fight.event.FightUntagEvent;
import com.eternalcode.combat.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import java.time.Duration;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BorderTriggerController
implements Listener {
    private static final long BORDER_WORK_AROUND_DELAY_MILLIS = 250L;
    private final BorderService borderService;
    private final Supplier<BorderSettings> border;
    private final FightManager fightManager;
    private final Server server;
    private final MinecraftScheduler scheduler;

    public BorderTriggerController(BorderService borderService, Supplier<BorderSettings> border, FightManager fightManager, Server server, MinecraftScheduler scheduler) {
        this.borderService = borderService;
        this.border = border;
        this.fightManager = fightManager;
        this.server = server;
        this.scheduler = scheduler;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onMove(PlayerMoveEvent event) {
        if (!this.border.get().isEnabled()) {
            return;
        }
        Location to = event.getTo();
        Location from = event.getFrom();
        if (to.getBlockX() == from.getBlockX() && to.getBlockY() == from.getBlockY() && to.getBlockZ() == from.getBlockZ()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.fightManager.isInCombat(player.getUniqueId())) {
            return;
        }
        this.borderService.updateBorder(player, to);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onTeleport(PlayerTeleportEvent event) {
        if (!this.border.get().isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.fightManager.isInCombat(player.getUniqueId())) {
            return;
        }
        this.borderService.updateBorder(player, event.getTo());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onFightStart(FightTagEvent event) {
        if (!this.border.get().isEnabled()) {
            return;
        }
        Player player = this.server.getPlayer(event.getPlayer());
        if (player == null) {
            return;
        }
        this.borderService.updateBorder(player, player.getLocation());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onFightEnd(FightUntagEvent event) {
        if (!this.border.get().isEnabled()) {
            return;
        }
        Player player = this.server.getPlayer(event.getPlayer());
        if (player == null) {
            return;
        }
        this.scheduler.runLater(() -> {
            if (!this.fightManager.isInCombat(player.getUniqueId())) {
                this.borderService.clearBorder(player);
            }
        }, Duration.ofMillis(250L));
    }
}

