/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat;

import com.eternalcode.combat.config.ConfigService;
import com.eternalcode.combat.libs.com.eternalcode.multification.bukkit.notice.BukkitNotice;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.async.Async;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.combat.notification.NoticeService;
import com.google.common.base.Stopwatch;
import java.time.Duration;
import org.bukkit.command.CommandSender;

@Command(name="combatlog", aliases={"combat"})
public class EternalCombatReloadCommand {
    private static final Notice RELOAD_MESSAGE = ((BukkitNotice.Builder)BukkitNotice.builder().chat("<b><gradient:#8a1212:#fc6b03>EternalCombat:</gradient></b> Reloaded EternalCombat in <color:#fce303>{TIME}ms!</color>")).build();
    private final ConfigService configService;
    private final NoticeService noticeService;

    public EternalCombatReloadCommand(ConfigService configService, NoticeService noticeService) {
        this.configService = configService;
        this.noticeService = noticeService;
    }

    @Async
    @Execute(name="reload")
    @Permission(value={"eternalcombat.reload"})
    void execute(@Context CommandSender sender) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.configService.reload();
        Duration elapsed = stopwatch.elapsed();
        this.noticeService.create().viewer(sender).notice(RELOAD_MESSAGE).placeholder("{TIME}", String.valueOf(elapsed.toMillis())).send();
    }
}

