/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.command;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandRoute;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandRouteExecutorReferenceImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandRouteImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.executor.CommandExecutor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CommandRoutePath {
    private final List<String> paths;

    private CommandRoutePath(List<String> paths) {
        this.paths = paths;
    }

    public <SENDER> CommandRoute<SENDER> createReference(CommandExecutor<SENDER> referenceTo) {
        CommandRouteReference first;
        String firstPath = this.paths.get(0);
        if (this.paths.size() == 1) {
            return new CommandRouteExecutorReferenceImpl(firstPath, referenceTo.getParent(), referenceTo);
        }
        CommandRouteReference current = first = new CommandRouteReference(firstPath, referenceTo.getParent());
        for (int i = 1; i < this.paths.size(); ++i) {
            String path = this.paths.get(i);
            if (i == this.paths.size() - 1) {
                current.appendChildren(new CommandRouteExecutorReferenceImpl(path, current, referenceTo));
                break;
            }
            CommandRouteReference route = new CommandRouteReference(path, current);
            current.appendChildren(route);
            current = route;
        }
        return first;
    }

    public static CommandRoutePath of(List<String> paths) {
        return new CommandRoutePath(paths);
    }

    public static CommandRoutePath from(String paths) {
        return new CommandRoutePath(Arrays.asList(paths.split(" ")));
    }

    private static class CommandRouteReference<S>
    extends CommandRouteImpl<S> {
        CommandRouteReference(String name, CommandRoute<S> parent) {
            super(name, Collections.emptyList(), parent);
        }

        @Override
        public boolean isReference() {
            return true;
        }
    }
}

