/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.command;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandRoute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CommandMerger<SENDER> {
    private final Map<String, CommandRoute<SENDER>> commandsByName = new HashMap<String, CommandRoute<SENDER>>();
    private final Map<UUID, CommandRoute<SENDER>> commands = new HashMap<UUID, CommandRoute<SENDER>>();

    public void merge(CommandRoute<SENDER> current) {
        for (String name : current.names()) {
            if (!this.commandsByName.containsKey(name)) continue;
            CommandRoute<SENDER> toRemove = this.commandsByName.get(name);
            CommandRoute<SENDER> mergedCommand = toRemove.merge(current);
            for (String commandName : mergedCommand.names()) {
                this.commandsByName.put(commandName, mergedCommand);
            }
            this.commands.remove(toRemove.getUniqueId());
            this.commands.put(mergedCommand.getUniqueId(), mergedCommand);
            return;
        }
        for (String name : current.names()) {
            this.commandsByName.put(name, current);
        }
        this.commands.put(current.getUniqueId(), current);
    }

    public Collection<CommandRoute<SENDER>> getMergedCommands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }
}

