/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.config;

import com.eternalcode.combat.border.animation.block.BlockTypeTransformer;
import com.eternalcode.combat.border.animation.particle.ParticleColorTransformer;
import com.eternalcode.combat.border.animation.particle.ParticleTypeTransformer;
import com.eternalcode.combat.libs.com.eternalcode.multification.bukkit.notice.resolver.sound.SoundBukkitResolver;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.NoticeResolverDefaults;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.NoticeResolverRegistry;
import com.eternalcode.combat.libs.com.eternalcode.multification.okaeri.MultificationSerdesPack;
import com.eternalcode.combat.libs.eu.okaeri.configs.ConfigManager;
import com.eternalcode.combat.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.SerdesRegistry;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.commons.SerdesCommons;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.SerdesBukkit;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class ConfigService {
    private final Set<OkaeriConfig> configs = new HashSet<OkaeriConfig>();

    public <T extends OkaeriConfig> T create(Class<T> config, File file) {
        T configFile = ConfigManager.create(config);
        YamlSnakeYamlConfigurer configurer = new YamlSnakeYamlConfigurer();
        NoticeResolverRegistry noticeRegistry = NoticeResolverDefaults.createRegistry().registerResolver(new SoundBukkitResolver());
        ((OkaeriConfig)configFile).withConfigurer(configurer, new SerdesCommons(), new SerdesBukkit(), new MultificationSerdesPack(noticeRegistry), new DefaultSerdesPack());
        ((OkaeriConfig)configFile).withBindFile(file);
        ((OkaeriConfig)configFile).withRemoveOrphans(true);
        ((OkaeriConfig)configFile).saveDefaults();
        ((OkaeriConfig)configFile).load(true);
        this.configs.add((OkaeriConfig)configFile);
        return configFile;
    }

    public void reload() {
        for (OkaeriConfig config : this.configs) {
            config.load();
        }
    }

    private static class DefaultSerdesPack
    implements OkaeriSerdesPack {
        private DefaultSerdesPack() {
        }

        @Override
        public void register(SerdesRegistry config) {
            config.register(new ParticleColorTransformer());
            config.register(new ParticleTypeTransformer());
            config.register(new BlockTypeTransformer());
        }
    }
}

