/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border;

import com.eternalcode.combat.border.BorderActivePointsIndex;
import com.eternalcode.combat.border.BorderLazyResult;
import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.BorderResult;
import com.eternalcode.combat.border.BorderService;
import com.eternalcode.combat.border.BorderSettings;
import com.eternalcode.combat.border.BorderTrigger;
import com.eternalcode.combat.border.BorderTriggerIndex;
import com.eternalcode.combat.border.event.BorderHideAsyncEvent;
import com.eternalcode.combat.border.event.BorderShowAsyncEvent;
import com.eternalcode.combat.event.EventManager;
import com.eternalcode.combat.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.Lazy;
import com.eternalcode.combat.region.RegionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class BorderServiceImpl
implements BorderService {
    private final MinecraftScheduler scheduler;
    private final EventManager eventManager;
    private final Supplier<BorderSettings> settings;
    private final BorderTriggerIndex borderIndexes;
    private final BorderActivePointsIndex activeBorderIndex = new BorderActivePointsIndex();

    public BorderServiceImpl(MinecraftScheduler scheduler, Server server, RegionProvider provider, EventManager eventManager, Supplier<BorderSettings> settings) {
        this.scheduler = scheduler;
        this.eventManager = eventManager;
        this.settings = settings;
        this.borderIndexes = BorderTriggerIndex.started(server, scheduler, provider, settings);
    }

    @Override
    public void updateBorder(Player player, Location location) {
        Optional<BorderResult> result = this.resolveBorder(location);
        String world = player.getWorld().getName();
        if (result.isEmpty()) {
            if (!this.activeBorderIndex.hasPoints(world, player.getUniqueId())) {
                return;
            }
            this.clearBorder(player);
            return;
        }
        this.scheduler.runAsync(() -> {
            Set<BorderPoint> removed;
            BorderResult borderResult = (BorderResult)result.get();
            Set<BorderPoint> points = borderResult.collect();
            if (!points.isEmpty()) {
                BorderShowAsyncEvent event = this.eventManager.publishEvent(new BorderShowAsyncEvent(player, points));
                points = event.getPoints();
            }
            if (!(removed = this.activeBorderIndex.putPoints(world, player.getUniqueId(), points)).isEmpty()) {
                this.eventManager.publishEvent(new BorderHideAsyncEvent(player, removed));
            }
        });
    }

    @Override
    public void clearBorder(Player player) {
        World world = player.getWorld();
        UUID uniqueId = player.getUniqueId();
        this.scheduler.runAsync(() -> {
            Set<BorderPoint> removed = this.activeBorderIndex.removePoints(world.getName(), uniqueId);
            if (!removed.isEmpty()) {
                this.eventManager.publishEvent(new BorderHideAsyncEvent(player, removed));
            }
        });
    }

    @Override
    public Set<BorderPoint> getActiveBorder(Player player) {
        return this.activeBorderIndex.getPoints(player.getWorld().getName(), player.getUniqueId());
    }

    private Optional<BorderResult> resolveBorder(Location location) {
        List<BorderTrigger> triggered = this.borderIndexes.getTriggered(location);
        if (triggered.isEmpty()) {
            return Optional.empty();
        }
        BorderLazyResult result = new BorderLazyResult();
        for (BorderTrigger trigger : triggered) {
            result.addLazyBorderPoints(new Lazy<List<BorderPoint>>(() -> this.resolveBorderPoints(trigger, location)));
        }
        return Optional.of(result);
    }

    private List<BorderPoint> resolveBorderPoints(BorderTrigger trigger, Location playerLocation) {
        int currentY;
        int currentY2;
        BorderPoint innerPoint;
        int currentZ;
        int currentX;
        BorderPoint borderMin = trigger.min();
        BorderPoint borderMax = trigger.max();
        int x = (int)Math.round(playerLocation.getX());
        int y = (int)Math.round(playerLocation.getY());
        int z = (int)Math.round(playerLocation.getZ());
        int distanceRounded = this.settings.get().distanceRounded();
        int realMinX = Math.max(borderMin.x(), x - distanceRounded);
        int realMaxX = Math.min(borderMax.x(), x + distanceRounded);
        int realMinY = Math.max(borderMin.y(), y - distanceRounded);
        int realMaxY = Math.min(borderMax.y(), y + distanceRounded);
        int realMinZ = Math.max(borderMin.z(), z - distanceRounded);
        int realMaxZ = Math.min(borderMax.z(), z + distanceRounded);
        ArrayList<BorderPoint> points = new ArrayList<BorderPoint>();
        if (borderMin.y() >= realMinY) {
            for (currentX = realMinX; currentX <= realMaxX - 1; ++currentX) {
                for (currentZ = realMinZ; currentZ <= realMaxZ - 1; ++currentZ) {
                    this.addPoint(points, currentX, realMinY, currentZ, playerLocation, null);
                }
            }
        }
        if (borderMax.y() <= realMaxY) {
            for (currentX = realMinX; currentX <= realMaxX; ++currentX) {
                for (currentZ = realMinZ; currentZ <= realMaxZ; ++currentZ) {
                    innerPoint = new BorderPoint(Math.max(realMinX, currentX - 1), realMaxY - 1, Math.max(realMinZ, currentZ - 1));
                    this.addPoint(points, currentX, realMaxY, currentZ, playerLocation, innerPoint);
                }
            }
        }
        if (borderMin.x() >= realMinX) {
            for (currentY2 = realMinY; currentY2 <= realMaxY - 1; ++currentY2) {
                for (currentZ = realMinZ; currentZ <= realMaxZ - 1; ++currentZ) {
                    this.addPoint(points, realMinX, currentY2, currentZ, playerLocation, null);
                }
            }
        }
        if (borderMax.x() <= realMaxX) {
            for (currentY2 = realMinY; currentY2 <= realMaxY; ++currentY2) {
                for (currentZ = realMinZ; currentZ <= realMaxZ; ++currentZ) {
                    innerPoint = new BorderPoint(realMaxX - 1, Math.max(realMinY, currentY2 - 1), Math.max(realMinZ, currentZ - 1));
                    this.addPoint(points, realMaxX, currentY2, currentZ, playerLocation, innerPoint);
                }
            }
        }
        if (borderMin.z() >= realMinZ) {
            for (currentX = realMinX; currentX <= realMaxX - 1; ++currentX) {
                for (currentY = realMinY; currentY <= realMaxY - 1; ++currentY) {
                    this.addPoint(points, currentX, currentY, realMinZ, playerLocation, null);
                }
            }
        }
        if (borderMax.z() <= realMaxZ) {
            for (currentX = realMinX; currentX <= realMaxX; ++currentX) {
                for (currentY = realMinY; currentY <= realMaxY; ++currentY) {
                    innerPoint = new BorderPoint(Math.max(realMinX, currentX - 1), Math.max(realMinY, currentY - 1), realMaxZ - 1);
                    this.addPoint(points, currentX, currentY, realMaxZ, playerLocation, innerPoint);
                }
            }
        }
        return points;
    }

    private void addPoint(List<BorderPoint> points, int x, int y, int z, Location playerLocation, BorderPoint innerPoint) {
        if (this.isVisible(x, y, z, playerLocation)) {
            points.add(new BorderPoint(x, y, z, innerPoint));
        }
    }

    private boolean isVisible(int x, int y, int z, Location player) {
        return Math.sqrt(Math.pow((double)x - player.getX(), 2.0) + Math.pow((double)y - player.getY(), 2.0) + Math.pow((double)z - player.getZ(), 2.0)) <= this.settings.get().distance;
    }
}

