/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.region.worldguard;

import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.region.Region;
import com.eternalcode.combat.region.RegionProvider;
import com.eternalcode.combat.region.worldguard.WorldGuardRegion;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class WorldGuardRegionProvider
implements RegionProvider {
    private final RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
    private final TreeSet<String> regions = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private final PluginConfig pluginConfig;

    public WorldGuardRegionProvider(PluginConfig pluginConfig) {
        this.regions.addAll(pluginConfig.regions.blockedRegions);
        this.pluginConfig = pluginConfig;
    }

    @Override
    public Optional<Region> getRegion(Location location) {
        RegionQuery regionQuery = this.regionContainer.createQuery();
        ApplicableRegionSet applicableRegions = regionQuery.getApplicableRegions(BukkitAdapter.adapt((Location)location));
        ProtectedRegion highestPriorityRegion = this.highestPriorityRegion(applicableRegions);
        if (highestPriorityRegion == null) {
            return Optional.empty();
        }
        if (this.isCombatRegion(highestPriorityRegion)) {
            return Optional.of(new WorldGuardRegion(location.getWorld(), highestPriorityRegion));
        }
        return Optional.empty();
    }

    @Override
    public Collection<Region> getRegions(World world) {
        RegionManager regionManager = this.regionContainer.get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return Collections.emptyList();
        }
        return regionManager.getRegions().values().stream().filter(region -> this.isCombatRegion((ProtectedRegion)region)).map(region -> new WorldGuardRegion(world, (ProtectedRegion)region)).toList();
    }

    private boolean isCombatRegion(ProtectedRegion region) {
        StateFlag.State flag;
        if (this.regions.contains(region.getId())) {
            return true;
        }
        if (this.pluginConfig.regions.preventPvpInRegions && (flag = (StateFlag.State)region.getFlag((Flag)Flags.PVP)) != null) {
            return flag.equals((Object)StateFlag.State.DENY);
        }
        return false;
    }

    @Nullable
    private ProtectedRegion highestPriorityRegion(ApplicableRegionSet applicableRegions) {
        return applicableRegions.getRegions().stream().max(Comparator.comparingInt(ProtectedRegion::getPriority)).orElse(null);
    }
}

