/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommands;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsAdvanced;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsBuilder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsInternal;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsProvider;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.LiteCommandsAnnotations;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.ArgumentKey;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.Parser;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserChained;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserRegistryImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.ArgumentResolverBase;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.ArgumentResolverBaseChained;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.Suggester;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.SuggesterChained;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.SuggesterRegistryImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.bind.BindChainedProvider;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.bind.BindRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandManager;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandMerger;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandRoute;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.builder.CommandBuilder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.builder.CommandBuilderCollector;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.executor.CommandExecuteService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.configurator.LiteConfigurator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.context.ContextChainedProvider;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.context.ContextRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.cooldown.CooldownService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.editor.Editor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.editor.EditorService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.event.Event;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.event.EventListener;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.event.EventPublisher;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.event.SimpleEventPublisher;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.extension.LiteCommandsProviderExtension;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.extension.LiteExtension;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.extension.annotations.AnnotationsExtension;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.extension.annotations.LiteAnnotationsProcessorExtension;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.handler.exception.ExceptionHandler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.handler.result.ResultHandleService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.handler.result.ResultHandleServiceImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.handler.result.ResultHandler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.InvokedMessage;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.Message;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.MessageKey;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.MessageRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.MissingPermissions;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.MissingPermissionsHandler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.PermissionResolver;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.PermissionService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.PermissionServiceImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.platform.Platform;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.platform.PlatformFactory;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.platform.PlatformSettings;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.platform.PlatformSettingsConfigurator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.processor.LiteBuilderAction;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.programmatic.LiteCommand;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.programmatic.LiteCommandsProgrammatic;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.type.TypeRange;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.requirement.RequirementMatchService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.Scheduler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.SchedulerExecutorPoolImpl;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.SchedulerReference;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicFastFormat;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicFastGenerator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicFormat;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicGenerator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicGeneratorReference;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SimpleSchematicGenerator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scope.Scope;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.Preconditions;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.strict.StrictMode;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.strict.StrictService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.validator.Validator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.validator.ValidatorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public class LiteCommandsBaseBuilder<SENDER, C extends PlatformSettings, B extends LiteCommandsBaseBuilder<SENDER, C, B>>
implements LiteCommandsBuilder<SENDER, C, B>,
LiteCommandsInternal<SENDER, C>,
LiteCommandsAdvanced<SENDER, C, B> {
    protected final Class<SENDER> senderClass;
    protected final Platform<SENDER, C> platform;
    protected final Set<LiteBuilderAction<SENDER, C>> preProcessors = new LinkedHashSet<LiteBuilderAction<SENDER, C>>();
    protected final Set<LiteBuilderAction<SENDER, C>> postProcessors = new LinkedHashSet<LiteBuilderAction<SENDER, C>>();
    protected final List<LiteExtension<SENDER, ?>> extensions = new ArrayList();
    protected final List<LiteCommandsProviderExtension<SENDER, ?>> commandsProviderExtensions = new ArrayList();
    protected final EditorService<SENDER> editorService;
    protected final PermissionServiceImpl permissionService;
    protected final ValidatorService<SENDER> validatorService;
    protected final ParserRegistry<SENDER> parserRegistry;
    protected final SuggesterRegistry<SENDER> suggesterRegistry;
    protected final BindRegistry bindRegistry;
    protected final ContextRegistry<SENDER> contextRegistry;
    protected final ResultHandleService<SENDER> resultHandleService;
    protected final CommandBuilderCollector<SENDER> commandBuilderCollector;
    protected final MessageRegistry<SENDER> messageRegistry;
    protected final StrictService strictService;
    protected final SchedulerReference scheduler;
    protected final EventPublisher eventPublisher;
    protected final SchematicGeneratorReference<SENDER> schematicGenerator;
    protected final CooldownService cooldownService;

    public LiteCommandsBaseBuilder(Class<SENDER> senderClass, PlatformFactory<SENDER, C> platform) {
        this(senderClass, platform, new EditorService(), new PermissionServiceImpl(), new ValidatorService(), new ParserRegistryImpl(), new SuggesterRegistryImpl(), new BindRegistry(), new ContextRegistry(), new ResultHandleServiceImpl(), new CommandBuilderCollector(), new MessageRegistry(), new StrictService());
    }

    public LiteCommandsBaseBuilder(Class<SENDER> senderClass, Platform<SENDER, C> platform) {
        this(senderClass, builder -> platform, new EditorService(), new PermissionServiceImpl(), new ValidatorService(), new ParserRegistryImpl(), new SuggesterRegistryImpl(), new BindRegistry(), new ContextRegistry(), new ResultHandleServiceImpl(), new CommandBuilderCollector(), new MessageRegistry(), new StrictService());
    }

    @ApiStatus.Experimental
    public LiteCommandsBaseBuilder(Class<SENDER> senderClass, PlatformFactory<SENDER, C> platform, EditorService<SENDER> editorService, PermissionServiceImpl permissionService, ValidatorService<SENDER> validatorService, ParserRegistry<SENDER> parserRegistry, SuggesterRegistry<SENDER> suggesterRegistry, BindRegistry bindRegistry, ContextRegistry<SENDER> contextRegistry, ResultHandleService<SENDER> resultHandleService, CommandBuilderCollector<SENDER> commandBuilderCollector, MessageRegistry<SENDER> messageRegistry, StrictService strictService) {
        this.senderClass = senderClass;
        this.editorService = editorService;
        this.validatorService = validatorService;
        this.permissionService = permissionService;
        this.parserRegistry = parserRegistry;
        this.suggesterRegistry = suggesterRegistry;
        this.bindRegistry = bindRegistry;
        this.contextRegistry = contextRegistry;
        this.resultHandleService = resultHandleService;
        this.commandBuilderCollector = commandBuilderCollector;
        this.messageRegistry = messageRegistry;
        this.strictService = strictService;
        this.scheduler = new SchedulerReference(new SchedulerExecutorPoolImpl("litecommands"));
        this.eventPublisher = new SimpleEventPublisher(bindRegistry);
        this.schematicGenerator = new SchematicGeneratorReference<SENDER>(new SchematicFastGenerator<SENDER>(SchematicFormat.angleBrackets(), permissionService, parserRegistry));
        this.cooldownService = new CooldownService(this.scheduler, permissionService, this.eventPublisher);
        this.platform = platform.createPlatform((LiteCommandsInternal<SENDER, C>)this.self());
    }

    @Override
    public <A extends LiteCommandsAdvanced<SENDER, C, A>> A advanced() {
        return (A)this;
    }

    @Override
    public B settings(PlatformSettingsConfigurator<C> configurator) {
        PlatformSettings newConfig = (PlatformSettings)configurator.apply(this.platform.getConfiguration());
        Preconditions.notNull(newConfig, "configuration");
        this.platform.setConfiguration(newConfig);
        return this.self();
    }

    @Override
    public B commands(LiteCommandsProvider<SENDER> commandsProvider) {
        this.preProcessExtensionsOnProvider(commandsProvider);
        this.commandBuilderCollector.add(commandsProvider.toInternalProvider(this));
        return this.self();
    }

    @Override
    public B commands(Object ... commands) {
        ArrayList<LiteCommandsProvider> providers = new ArrayList<LiteCommandsProvider>();
        ArrayList programmatic = new ArrayList();
        ArrayList<Class> classes = new ArrayList<Class>();
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Object command : commands) {
            if (command instanceof Collection) {
                this.commands(((Collection)command).toArray());
                continue;
            }
            if (command.getClass().isArray()) {
                this.commands((Object[])command);
                continue;
            }
            if (command instanceof LiteCommandsProvider) {
                providers.add((LiteCommandsProvider)command);
                continue;
            }
            if (command instanceof LiteCommand) {
                programmatic.add((LiteCommand)command);
                continue;
            }
            if (command instanceof Class) {
                classes.add((Class)command);
                continue;
            }
            instances.add(command);
        }
        for (LiteCommandsProvider provider : providers) {
            this.commands(provider);
        }
        if (!programmatic.isEmpty()) {
            this.commands((LiteCommandsProvider)LiteCommandsProgrammatic.of(programmatic));
        }
        if (!classes.isEmpty() || !instances.isEmpty()) {
            this.commands((LiteCommandsProvider)LiteCommandsAnnotations.create().load(instances.toArray(new Object[0])).loadClasses(classes.toArray(new Class[0])));
        }
        return this.self();
    }

    private void preProcessExtensionsOnProvider(LiteCommandsProvider<SENDER> commandsProvider) {
        this.beforeBuild((builder, internal) -> {
            for (LiteCommandsProviderExtension<SENDER, ?> extension : this.commandsProviderExtensions) {
                extension.extendCommandsProvider(this, this, commandsProvider);
            }
        });
    }

    @Override
    public <T> B argumentParser(Class<T> type, Parser<SENDER, T> parser) {
        return (B)this.argumentParser((TypeRange)TypeRange.same(type), ArgumentKey.of(), (Parser)parser);
    }

    @Override
    public <T> B argumentParser(Class<T> type, ParserChained<SENDER, T> parser) {
        return (B)this.argumentParser((TypeRange)TypeRange.same(type), ArgumentKey.of(), (ParserChained)parser);
    }

    @Override
    public <PARSED> B argumentParser(Class<PARSED> type, ArgumentKey key, Parser<SENDER, PARSED> parser) {
        return (B)this.argumentParser((TypeRange)TypeRange.same(type), key, (Parser)parser);
    }

    @Override
    public <PARSED> B argumentParser(Class<PARSED> type, ArgumentKey key, ParserChained<SENDER, PARSED> parser) {
        return (B)this.argumentParser((TypeRange)TypeRange.same(type), key, (ParserChained)parser);
    }

    @Override
    public <PARSED> B argumentParser(TypeRange<PARSED> type, ArgumentKey key, Parser<SENDER, PARSED> parser) {
        this.parserRegistry.registerParser(type, key, parser);
        return this.self();
    }

    @Override
    public <PARSED> B argumentParser(TypeRange<PARSED> type, ArgumentKey key, ParserChained<SENDER, PARSED> parser) {
        this.parserRegistry.registerParser(type, key, parser);
        return this.self();
    }

    @Override
    public <T> B argumentSuggestion(Class<T> type, SuggestionResult suggestion) {
        return (B)this.argumentSuggestion((TypeRange)TypeRange.same(type), ArgumentKey.of(), suggestion);
    }

    @Override
    public <T> B argumentSuggestion(Class<T> type, ArgumentKey key, SuggestionResult suggestion) {
        return (B)this.argumentSuggestion((TypeRange)TypeRange.same(type), key, suggestion);
    }

    @Override
    public <T> B argumentSuggestion(TypeRange<T> type, ArgumentKey key, SuggestionResult suggestion) {
        this.suggesterRegistry.registerSuggester(type, key, (invocation, argument, context) -> suggestion);
        return this.self();
    }

    @Override
    public <T> B argumentSuggester(Class<T> type, Suggester<SENDER, T> suggester) {
        return (B)this.argumentSuggester((TypeRange)TypeRange.same(type), ArgumentKey.of(), (Suggester)suggester);
    }

    @Override
    public <T> B argumentSuggester(Class<T> type, SuggesterChained<SENDER, T> suggester) {
        return (B)this.argumentSuggester((TypeRange)TypeRange.same(type), ArgumentKey.of(), (SuggesterChained)suggester);
    }

    @Override
    public <T> B argumentSuggester(Class<T> type, ArgumentKey key, Suggester<SENDER, T> suggester) {
        return (B)this.argumentSuggester((TypeRange)TypeRange.same(type), key, (Suggester)suggester);
    }

    @Override
    public <T> B argumentSuggester(Class<T> type, ArgumentKey key, SuggesterChained<SENDER, T> suggester) {
        return (B)this.argumentSuggester((TypeRange)TypeRange.same(type), key, (SuggesterChained)suggester);
    }

    @Override
    public <T> B argumentSuggester(TypeRange<T> type, ArgumentKey key, Suggester<SENDER, T> suggester) {
        this.suggesterRegistry.registerSuggester(type, key, suggester);
        return this.self();
    }

    @Override
    public <T> B argumentSuggester(TypeRange<T> type, ArgumentKey key, SuggesterChained<SENDER, T> suggester) {
        this.suggesterRegistry.registerSuggester(type, key, suggester);
        return this.self();
    }

    @Override
    public <T> B argument(Class<T> type, ArgumentResolverBase<SENDER, T> resolver) {
        return (B)this.argument((TypeRange)TypeRange.same(type), ArgumentKey.of(), (ArgumentResolverBase)resolver);
    }

    @Override
    public <T> B argument(Class<T> type, ArgumentResolverBaseChained<SENDER, T> resolver) {
        return (B)this.argument((TypeRange)TypeRange.same(type), ArgumentKey.of(), (ArgumentResolverBaseChained)resolver);
    }

    @Override
    public <T> B argument(Class<T> type, ArgumentKey key, ArgumentResolverBase<SENDER, T> resolver) {
        return (B)this.argument((TypeRange)TypeRange.same(type), key, (ArgumentResolverBase)resolver);
    }

    @Override
    public <T> B argument(Class<T> type, ArgumentKey key, ArgumentResolverBaseChained<SENDER, T> resolver) {
        return (B)this.argument((TypeRange)TypeRange.same(type), key, (ArgumentResolverBaseChained)resolver);
    }

    @Override
    public <T> B argument(TypeRange<T> type, ArgumentResolverBase<SENDER, T> resolver) {
        return (B)this.argument((TypeRange)type, ArgumentKey.of(), (ArgumentResolverBase)resolver);
    }

    @Override
    public <T> B argument(TypeRange<T> type, ArgumentResolverBaseChained<SENDER, T> resolver) {
        return (B)this.argument((TypeRange)type, ArgumentKey.of(), (ArgumentResolverBaseChained)resolver);
    }

    @Override
    public <T> B argument(TypeRange<T> type, ArgumentKey key, ArgumentResolverBase<SENDER, T> resolver) {
        this.argumentParser((TypeRange)type, key, (Parser)resolver);
        this.argumentSuggester((TypeRange)type, key, (Suggester)resolver);
        return this.self();
    }

    @Override
    public <T> B argument(TypeRange<T> type, ArgumentKey key, ArgumentResolverBaseChained<SENDER, T> resolver) {
        this.argumentParser((TypeRange)type, key, (ParserChained)resolver);
        this.argumentSuggester((TypeRange)type, key, (SuggesterChained)resolver);
        return this.self();
    }

    @Override
    public <T> B context(Class<T> on, ContextChainedProvider<SENDER, T> bind) {
        this.contextRegistry.registerProvider(on, bind);
        return this.self();
    }

    @Override
    public <T> B bind(Class<T> on, BindChainedProvider<T> bindProvider) {
        this.bindRegistry.bindInstance(on, bindProvider);
        return this.self();
    }

    @Override
    public LiteCommandsInternal<SENDER, C> internal() {
        return this;
    }

    @Override
    public <T> B bind(Class<T> on, Supplier<T> bind) {
        this.bindRegistry.bindInstance(on, bind);
        return this.self();
    }

    @Override
    public B bindUnsafe(Class<?> on, Supplier<?> bind) {
        this.bindRegistry.bindInstanceUnsafe(on, bind);
        return this.self();
    }

    @Override
    public B scheduler(Scheduler scheduler) {
        this.scheduler.setScheduler(scheduler);
        return this.self();
    }

    @Override
    public <T, CONTEXT> B message(MessageKey<CONTEXT> key, Message<T, CONTEXT> message) {
        this.messageRegistry.register(key, message);
        return this.self();
    }

    @Override
    public <T, CONTEXT> B message(MessageKey<CONTEXT> key, InvokedMessage<SENDER, T, CONTEXT> message) {
        this.messageRegistry.register(key, message);
        return this.self();
    }

    @Override
    public <T, CONTEXT> B message(MessageKey<CONTEXT> key, T message) {
        this.messageRegistry.register(key, context -> message);
        return this.self();
    }

    @Override
    public B editorGlobal(Editor<SENDER> editor) {
        this.editorService.editorGlobal(editor);
        return this.self();
    }

    @Override
    public B editor(Scope scope, Editor<SENDER> editor) {
        this.editorService.editor(scope, editor);
        return this.self();
    }

    @Override
    public B validatorGlobal(Validator<SENDER> validator) {
        this.validatorService.registerValidatorGlobal(validator);
        return this.self();
    }

    @Override
    public B validator(Scope scope, Validator<SENDER> validator) {
        this.validatorService.registerValidator(scope, validator);
        return this.self();
    }

    @Override
    public <T> B result(Class<T> resultType, ResultHandler<SENDER, ? extends T> handler) {
        this.resultHandleService.registerHandler(resultType, handler);
        return this.self();
    }

    @Override
    public B resultUnexpected(ResultHandler<SENDER, Object> handler) {
        this.resultHandleService.registerHandler(Object.class, handler);
        return this.self();
    }

    @Override
    public <E extends Throwable> B exception(Class<E> exceptionType, ExceptionHandler<SENDER, ? extends E> handler) {
        this.resultHandleService.registerHandler(exceptionType, handler);
        return this.self();
    }

    @Override
    public B exceptionUnexpected(ExceptionHandler<SENDER, Throwable> handler) {
        this.resultHandleService.registerHandler(Throwable.class, handler);
        return this.self();
    }

    @Override
    public B missingPermission(MissingPermissionsHandler<SENDER> handler) {
        this.resultHandleService.registerHandler(MissingPermissions.class, handler);
        return this.self();
    }

    @Override
    public B invalidUsage(InvalidUsageHandler<SENDER> handler) {
        this.resultHandleService.registerHandler(InvalidUsage.class, handler);
        return this.self();
    }

    @Override
    public B schematicGenerator(SchematicGenerator<SENDER> schematicGenerator) {
        this.schematicGenerator.setSchematicGenerator(schematicGenerator);
        return this.self();
    }

    @Override
    public B schematicGenerator(SchematicFormat format) {
        this.schematicGenerator.setSchematicGenerator(new SimpleSchematicGenerator<SENDER>(format, this.permissionService, this.parserRegistry));
        return this.self();
    }

    @Override
    public B schematicGenerator(SchematicFastFormat format) {
        this.schematicGenerator.setSchematicGenerator(new SchematicFastGenerator<SENDER>(format, this.permissionService, this.parserRegistry));
        return this.self();
    }

    @Override
    public B strictMode(StrictMode strictMode) {
        this.strictService.setDefaultMode(strictMode);
        return this.self();
    }

    @Override
    public B listener(EventListener listener) {
        this.eventPublisher.subscribe(listener);
        return this.self();
    }

    @Override
    public <E extends Event> B listener(Class<E> event, Consumer<E> listener) {
        this.eventPublisher.subscribe(event, listener);
        return this.self();
    }

    @Override
    public B self(LiteBuilderAction<SENDER, C> action) {
        action.process(this, this);
        return this.self();
    }

    @Override
    public B beforeBuild(LiteBuilderAction<SENDER, C> action) {
        this.preProcessors.add(action);
        return this.self();
    }

    @Override
    public B afterBuild(LiteBuilderAction<SENDER, C> action) {
        this.postProcessors.add(action);
        return this.self();
    }

    @Override
    public B permissionResolver(PermissionResolver permissionResolver) {
        this.permissionService.setPermissionResolver(permissionResolver);
        return this.self();
    }

    @Override
    public <CONFIGURATION> B extension(LiteExtension<SENDER, CONFIGURATION> extension) {
        return (B)this.extension(extension, (T configuration) -> {});
    }

    @Override
    public <CONFIGURATION, E extends LiteExtension<SENDER, CONFIGURATION>> B extension(E extension, LiteConfigurator<CONFIGURATION> configurator) {
        extension.configure(configurator);
        extension.extend(this, this);
        this.extensions.add(extension);
        if (extension instanceof LiteCommandsProviderExtension) {
            this.commandsProviderExtensions.add((LiteCommandsProviderExtension)extension);
        }
        return this.self();
    }

    @Override
    public B annotations(LiteConfigurator<AnnotationsExtension<SENDER>> configuration) {
        return (B)this.extension(new LiteAnnotationsProcessorExtension(), configuration);
    }

    @Override
    public LiteCommands<SENDER> build() {
        return this.build(true);
    }

    @Override
    public LiteCommands<SENDER> build(boolean register) {
        if (this.platform == null) {
            throw new IllegalStateException("No platform was set");
        }
        for (LiteBuilderAction<SENDER, C> processor : this.preProcessors) {
            processor.process(this, this);
        }
        CommandManager<SENDER> commandManager = this.createCommandManager();
        CommandMerger<SENDER> commandMerger = new CommandMerger<SENDER>();
        for (CommandBuilder<SENDER> commandBuilder : this.commandBuilderCollector.collectCommands()) {
            CommandBuilder<SENDER> edited = this.editorService.edit(commandBuilder);
            if (!edited.buildable()) continue;
            for (CommandRoute<SENDER> commandRoute : edited.build(commandManager.getRoot())) {
                commandMerger.merge(commandRoute);
            }
        }
        for (CommandRoute commandRoute : commandMerger.getMergedCommands()) {
            commandManager.register(commandRoute);
        }
        for (LiteBuilderAction liteBuilderAction : this.postProcessors) {
            liteBuilderAction.process(this, this);
        }
        LiteCommandsImpl<SENDER> liteCommand = new LiteCommandsImpl<SENDER>(commandManager, this);
        if (register) {
            liteCommand.register();
        }
        return liteCommand;
    }

    protected CommandManager<SENDER> createCommandManager() {
        RequirementMatchService<SENDER> requirementMatchService = new RequirementMatchService<SENDER>(this.strictService, this.contextRegistry, this.parserRegistry, this.bindRegistry, this.scheduler);
        CommandExecuteService<SENDER> commandExecuteService = new CommandExecuteService<SENDER>(this.resultHandleService, this.scheduler, requirementMatchService, this.eventPublisher);
        SuggestionService<SENDER> suggestionService = new SuggestionService<SENDER>(this.parserRegistry, this.suggesterRegistry, this.validatorService, this.eventPublisher);
        return new CommandManager<SENDER>(this.platform, commandExecuteService, suggestionService);
    }

    @Override
    @ApiStatus.Internal
    public Class<SENDER> getSenderClass() {
        return this.senderClass;
    }

    @Override
    @ApiStatus.Internal
    public Platform<SENDER, C> getPlatform() {
        return this.platform;
    }

    @Override
    @ApiStatus.Internal
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    @ApiStatus.Internal
    public SchematicGenerator<SENDER> getSchematicGenerator() {
        return this.schematicGenerator;
    }

    @Override
    @ApiStatus.Internal
    public EditorService<SENDER> getEditorService() {
        return this.editorService;
    }

    @Override
    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    @Override
    @ApiStatus.Internal
    public ValidatorService<SENDER> getValidatorService() {
        return this.validatorService;
    }

    @Override
    @ApiStatus.Internal
    public ParserRegistry<SENDER> getParserRegistry() {
        return this.parserRegistry;
    }

    @Override
    @ApiStatus.Internal
    public SuggesterRegistry<SENDER> getSuggesterRegistry() {
        return this.suggesterRegistry;
    }

    @Override
    @ApiStatus.Internal
    public BindRegistry getBindRegistry() {
        return this.bindRegistry;
    }

    @Override
    @ApiStatus.Internal
    public ContextRegistry<SENDER> getContextRegistry() {
        return this.contextRegistry;
    }

    @Override
    @ApiStatus.Internal
    public ResultHandleService<SENDER> getResultService() {
        return this.resultHandleService;
    }

    @Override
    @ApiStatus.Internal
    public CommandBuilderCollector<SENDER> getCommandBuilderCollector() {
        return this.commandBuilderCollector;
    }

    @Override
    @ApiStatus.Internal
    public MessageRegistry<SENDER> getMessageRegistry() {
        return this.messageRegistry;
    }

    @Override
    @ApiStatus.Internal
    public StrictService getStrictService() {
        return this.strictService;
    }

    @Override
    public CooldownService getCooldownService() {
        return this.cooldownService;
    }

    protected B self() {
        return (B)this;
    }
}

