/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.time;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.Lazy;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class TemporalAmountParser<T extends TemporalAmount> {
    private static final Map<ChronoUnit, BigInteger> UNIT_TO_NANO = new LinkedHashMap<ChronoUnit, BigInteger>();
    private final ChronoUnit defaultZero;
    private final Lazy<String> defaultZeroSymbol;
    private final Map<String, ChronoUnit> units = new LinkedHashMap<String, ChronoUnit>();
    private final Set<TimeModifier> modifiers = new HashSet<TimeModifier>();
    private final LocalDateTimeProvider baseForTimeEstimation;

    protected TemporalAmountParser(ChronoUnit defaultZero, Map<String, ChronoUnit> units, Set<TimeModifier> modifiers, LocalDateTimeProvider baseForTimeEstimation) {
        this(defaultZero, baseForTimeEstimation);
        this.units.putAll(units);
        this.modifiers.addAll(modifiers);
    }

    protected TemporalAmountParser(ChronoUnit defaultZero, LocalDateTimeProvider baseForTimeEstimation) {
        this.defaultZero = defaultZero;
        this.baseForTimeEstimation = baseForTimeEstimation;
        this.defaultZeroSymbol = new Lazy<String>(() -> this.units.entrySet().stream().filter(entry -> entry.getValue() == defaultZero).map(entry -> (String)entry.getKey()).findFirst().orElseThrow(() -> new IllegalStateException("Can not find default zero symbol for " + defaultZero)));
    }

    public TemporalAmountParser<T> withUnit(String symbol, ChronoUnit chronoUnit) {
        if (this.units.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol " + symbol + " is already used");
        }
        if (!this.validCharacters(symbol, Character::isLetter)) {
            throw new IllegalArgumentException("Symbol " + symbol + " contains non-letter characters");
        }
        LinkedHashMap<String, ChronoUnit> newUnits = new LinkedHashMap<String, ChronoUnit>(this.units);
        newUnits.put(symbol, chronoUnit);
        return this.clone(this.defaultZero, newUnits, this.modifiers, this.baseForTimeEstimation);
    }

    public TemporalAmountParser<T> withLocalDateTimeProvider(LocalDateTimeProvider baseForTimeEstimation) {
        return this.clone(this.defaultZero, this.units, this.modifiers, baseForTimeEstimation);
    }

    public TemporalAmountParser<T> withDefaultZero(ChronoUnit defaultZero) {
        return this.clone(defaultZero, this.units, this.modifiers, this.baseForTimeEstimation);
    }

    public TemporalAmountParser<T> withRounded(ChronoUnit unit, RoundingMode roundingMode) {
        return this.withTimeModifier(duration -> {
            BigInteger nanosInUnit = UNIT_TO_NANO.get(unit);
            BigInteger nanos = this.durationToNano(duration);
            BigInteger rounded = TemporalAmountParser.round(roundingMode, nanos, nanosInUnit);
            return Duration.ofNanos(rounded.longValue());
        });
    }

    private static BigInteger round(RoundingMode roundingMode, BigInteger nanos, BigInteger nanosInUnit) {
        BigInteger roundedUp;
        BigInteger remainder = nanos.remainder(nanosInUnit);
        BigInteger subtract = nanos.subtract(remainder);
        BigInteger add = subtract.add(nanosInUnit);
        BigInteger bigInteger = remainder.equals(BigInteger.ZERO) ? nanos : (roundedUp = nanos.signum() > 0 ? add : subtract.subtract(nanosInUnit));
        BigInteger roundedDown = remainder.equals(BigInteger.ZERO) ? nanos : (nanos.signum() > 0 ? subtract : add.subtract(nanosInUnit));
        int compare = remainder.abs().multiply(BigInteger.valueOf(2L)).compareTo(nanosInUnit);
        switch (roundingMode) {
            case UP: {
                return roundedUp;
            }
            case DOWN: {
                return roundedDown;
            }
            case CEILING: {
                return nanos.signum() >= 0 ? roundedUp : roundedDown;
            }
            case FLOOR: {
                return nanos.signum() >= 0 ? roundedDown : roundedUp;
            }
            case HALF_UP: {
                return compare >= 0 ? roundedUp : roundedDown;
            }
            case HALF_DOWN: {
                return compare > 0 ? roundedUp : roundedDown;
            }
        }
        throw new IllegalArgumentException("Unsupported rounding mode " + (Object)((Object)roundingMode));
    }

    private TemporalAmountParser<T> withTimeModifier(TimeModifier modifier) {
        HashSet<TimeModifier> newRoundedUnits = new HashSet<TimeModifier>(this.modifiers);
        newRoundedUnits.add(modifier);
        return this.clone(this.defaultZero, this.units, newRoundedUnits, this.baseForTimeEstimation);
    }

    protected abstract TemporalAmountParser<T> clone(ChronoUnit var1, Map<String, ChronoUnit> var2, Set<TimeModifier> var3, LocalDateTimeProvider var4);

    private boolean validCharacters(String content, Predicate<Character> predicate) {
        for (int i = 0; i < content.length(); ++i) {
            if (predicate.test(Character.valueOf(content.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public T parse(String input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Input is empty");
        }
        T total = this.getZero();
        boolean negative = false;
        StringBuilder number = new StringBuilder();
        StringBuilder unit = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '-') {
                if (i != 0) {
                    throw new IllegalArgumentException("Minus sign is only allowed at the start of the input");
                }
                negative = true;
                continue;
            }
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            if (!Character.isLetter(c)) {
                throw new IllegalArgumentException("Invalid character " + c + " in input");
            }
            unit.append(c);
            if (i != input.length() - 1 && !Character.isDigit(input.charAt(i + 1))) continue;
            TemporalEntry temporalEntry = this.parseTemporal(number.toString(), unit.toString());
            total = this.plus(this.baseForTimeEstimation, total, temporalEntry);
            number.setLength(0);
            unit.setLength(0);
        }
        if (number.length() > 0 || unit.length() > 0) {
            throw new IllegalArgumentException("Input is not in the format of <number><unit>");
        }
        if (negative) {
            total = this.negate(total);
        }
        return total;
    }

    protected abstract T plus(LocalDateTimeProvider var1, T var2, TemporalEntry var3);

    protected abstract T negate(T var1);

    protected abstract T getZero();

    private TemporalEntry parseTemporal(String number, String unit) {
        if (number.isEmpty()) {
            throw new IllegalArgumentException("Missing number before unit " + unit);
        }
        ChronoUnit chronoUnit = this.units.get(unit);
        if (chronoUnit == null) {
            throw new IllegalArgumentException("Unknown unit " + unit);
        }
        try {
            long count = Long.parseLong(number);
            return new TemporalEntry(count, chronoUnit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number " + number);
        }
    }

    public String format(T temporalAmount) {
        StringBuilder builder = new StringBuilder();
        Duration duration = this.toDuration(this.baseForTimeEstimation, temporalAmount);
        for (TimeModifier timeModifier : this.modifiers) {
            duration = timeModifier.modify(duration);
        }
        if (duration.isNegative()) {
            builder.append('-');
            duration = duration.negated();
        }
        ArrayList<String> keys = new ArrayList<String>(this.units.keySet());
        Collections.reverse(keys);
        for (String key : keys) {
            ChronoUnit unit = this.units.get(key);
            BigInteger nanosInOneUnit = UNIT_TO_NANO.get(unit);
            if (nanosInOneUnit == null) {
                throw new IllegalArgumentException("Unsupported unit " + unit);
            }
            BigInteger nanosCount = this.durationToNano(duration);
            BigInteger count = nanosCount.divide(nanosInOneUnit);
            if (count.equals(BigInteger.ZERO)) continue;
            BigInteger nanosCountCleared = count.multiply(nanosInOneUnit);
            builder.append(count).append(key);
            duration = duration.minusNanos(nanosCountCleared.longValue());
        }
        String string = builder.toString();
        if (string.isEmpty()) {
            String defaultSymbol = this.defaultZeroSymbol.get();
            return "0" + defaultSymbol;
        }
        return string;
    }

    protected abstract Duration toDuration(LocalDateTimeProvider var1, T var2);

    private BigInteger durationToNano(Duration duration) {
        return BigInteger.valueOf(duration.getSeconds()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(duration.getNano()));
    }

    static {
        UNIT_TO_NANO.put(ChronoUnit.NANOS, BigInteger.valueOf(1L));
        UNIT_TO_NANO.put(ChronoUnit.MICROS, BigInteger.valueOf(1000L));
        UNIT_TO_NANO.put(ChronoUnit.MILLIS, BigInteger.valueOf(1000000L));
        UNIT_TO_NANO.put(ChronoUnit.SECONDS, BigInteger.valueOf(1000000000L));
        UNIT_TO_NANO.put(ChronoUnit.MINUTES, BigInteger.valueOf(60000000000L));
        UNIT_TO_NANO.put(ChronoUnit.HOURS, BigInteger.valueOf(3600000000000L));
        UNIT_TO_NANO.put(ChronoUnit.DAYS, BigInteger.valueOf(86400000000000L));
        UNIT_TO_NANO.put(ChronoUnit.WEEKS, BigInteger.valueOf(604800000000000L));
        UNIT_TO_NANO.put(ChronoUnit.MONTHS, BigInteger.valueOf(2592000000000000L));
        UNIT_TO_NANO.put(ChronoUnit.YEARS, BigInteger.valueOf(31536000000000000L));
        UNIT_TO_NANO.put(ChronoUnit.DECADES, BigInteger.valueOf(315360000000000000L));
    }

    protected static interface TimeModifier {
        public Duration modify(Duration var1);
    }

    public static interface LocalDateTimeProvider {
        public LocalDateTime get();

        public static LocalDateTimeProvider now() {
            return LocalDateTime::now;
        }

        public static LocalDateTimeProvider startOfToday() {
            return LocalDateTimeProvider.of(LocalDate.now());
        }

        public static LocalDateTimeProvider of(LocalDateTime localDateTime) {
            return () -> localDateTime;
        }

        public static LocalDateTimeProvider of(LocalDate localDate) {
            return localDate::atStartOfDay;
        }
    }

    protected static class TemporalEntry {
        private final long count;
        private final ChronoUnit unit;

        public TemporalEntry(long count, ChronoUnit unit) {
            this.count = count;
            this.unit = unit;
        }

        public long getCount() {
            return this.count;
        }

        public ChronoUnit getUnit() {
            return this.unit;
        }
    }
}

