/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.standard;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.LiteMessages;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.MessageRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

public class UUIDArgumentResolver<SENDER>
extends ArgumentResolver<SENDER, UUID> {
    private final MessageRegistry<SENDER> messageRegistry;
    private final SuggestionResult suggestions;

    public UUIDArgumentResolver(MessageRegistry<SENDER> messageRegistry) {
        this.messageRegistry = messageRegistry;
        this.suggestions = Stream.generate(() -> UUID.randomUUID().toString()).limit(10L).map(str -> ThreadLocalRandom.current().nextBoolean() ? str.replace("-", "") : str).collect(SuggestionResult.collector());
    }

    @Override
    protected ParseResult<UUID> parse(Invocation<SENDER> invocation, Argument<UUID> context, String argument) {
        try {
            if (argument.length() == 36) {
                return ParseResult.success(UUID.fromString(argument));
            }
            if (argument.length() == 32) {
                return ParseResult.success(UUID.fromString(new StringBuilder(argument).insert(8, '-').insert(13, '-').insert(18, '-').insert(23, '-').toString()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ParseResult.failure(this.messageRegistry.get(LiteMessages.UUID_INVALID_FORMAT, invocation, argument));
    }

    @Override
    public SuggestionResult suggest(Invocation<SENDER> invocation, Argument<UUID> argument, SuggestionContext context) {
        return this.suggestions;
    }
}

