/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache;

import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Expiry;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Pacer;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.SILMW;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Scheduler;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Ticker;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.TimerWheel;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

class SILMWA<K, V>
extends SILMW<K, V> {
    static final LocalCacheFactory FACTORY = SILMWA::new;
    protected static final VarHandle EXPIRES_AFTER_ACCESS_NANOS;
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    SILMWA(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.setExpiresAfterAccessNanos(caffeine.getExpiresAfterAccessNanos());
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return EXPIRES_AFTER_ACCESS_NANOS.getAcquire(this);
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        EXPIRES_AFTER_ACCESS_NANOS.setRelease(this, l);
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            EXPIRES_AFTER_ACCESS_NANOS = lookup.findVarHandle(SILMWA.class, "expiresAfterAccessNanos", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

