/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.crystalpvp;

import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.crystalpvp.CrystalMetadata;
import com.eternalcode.combat.crystalpvp.CrystalPvpConstants;
import com.eternalcode.combat.fight.FightManager;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class EndCrystalListener
implements Listener {
    private final Plugin plugin;
    private final FightManager fightManager;
    private final PluginConfig pluginConfig;

    public EndCrystalListener(Plugin plugin, FightManager fightManager, PluginConfig pluginConfig) {
        this.plugin = plugin;
        this.fightManager = fightManager;
        this.pluginConfig = pluginConfig;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onPlayerDamageCrystal(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EnderCrystal) {
            Entity entity2;
            Arrow arrow;
            EnderCrystal enderCrystal = (EnderCrystal)entity;
            Entity entity3 = event.getDamager();
            if (entity3 instanceof Arrow && (entity3 = (arrow = (Arrow)entity3).getShooter()) instanceof Player) {
                Player player = (Player)entity3;
                enderCrystal.setMetadata("eternalcombat:crystal", (MetadataValue)new CrystalMetadata(this.plugin, player.getUniqueId()));
            }
            if (!((entity2 = event.getDamager()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity2;
            enderCrystal.setMetadata("eternalcombat:crystal", (MetadataValue)new CrystalMetadata(this.plugin, player.getUniqueId()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onDamage(EntityDamageByEntityEvent event) {
        if (!this.pluginConfig.crystalPvp.tagFromCrystals) {
            return;
        }
        if (this.pluginConfig.settings.ignoredWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        Optional<UUID> optionalDamagerUUID = CrystalPvpConstants.getDamagerUniqueIdFromEndCrystal(event);
        if (optionalDamagerUUID.isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CrystalPvpConstants.handleCombatTag(optionalDamagerUUID, player, this.fightManager, this.pluginConfig);
        }
    }
}

