/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.SchedulerType;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.ThrowingRunnable;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.ThrowingSupplier;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public interface Scheduler {
    default public CompletableFuture<Void> run(SchedulerType type, ThrowingRunnable<Throwable> runnable) {
        return this.supply(type, () -> {
            runnable.run();
            return null;
        });
    }

    default public CompletableFuture<Void> runLater(SchedulerType type, Duration delay, ThrowingRunnable<Throwable> runnable) {
        return this.supplyLater(type, delay, () -> {
            runnable.run();
            return null;
        });
    }

    default public <T> CompletableFuture<T> supply(SchedulerType type, ThrowingSupplier<T, Throwable> supplier) {
        return this.supplyLater(type, Duration.ZERO, supplier);
    }

    public <T> CompletableFuture<T> supplyLater(SchedulerType var1, Duration var2, ThrowingSupplier<T, Throwable> var3);

    public void shutdown();
}

