/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.input.raw;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.Parser;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.input.raw.RawInput;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.range.Range;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.Preconditions;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class RawInputAnalyzer {
    private final List<String> rawArguments;
    private int lastPivotPosition = 0;
    private int pivotPosition = 0;
    private boolean isLastOptionalArgument = false;

    public RawInputAnalyzer(List<String> rawArguments) {
        for (String rawArgument : rawArguments) {
            Preconditions.notNull(rawArgument, "raw argument");
        }
        this.rawArguments = rawArguments;
    }

    public int getPivotPosition() {
        return this.pivotPosition;
    }

    public void setPivotPosition(int pivotPosition) {
        this.lastPivotPosition = this.pivotPosition;
        this.pivotPosition = pivotPosition;
    }

    public boolean hasNextRoute() {
        return this.pivotPosition < this.rawArguments.size();
    }

    public <SENDER, T> Context<SENDER, T> toContext(Argument<T> argument, Parser<SENDER, T> parser) {
        return new Context<SENDER, T>(argument, parser);
    }

    public String showNextRoute() {
        return this.rawArguments.get(this.pivotPosition);
    }

    public String nextRoute() {
        return this.rawArguments.get(this.pivotPosition++);
    }

    public List<String> getLastArgumentsBeforePivotMove() {
        return this.rawArguments.subList(this.lastPivotPosition, this.pivotPosition);
    }

    public boolean nextRouteIsLast() {
        return this.pivotPosition == this.rawArguments.size() - 1;
    }

    @ApiStatus.Experimental
    public void setLastOptionalArgument(boolean setLastOptionalArgument) {
        this.isLastOptionalArgument = setLastOptionalArgument;
    }

    public void consumeAll() {
        this.setPivotPosition(this.rawArguments.size());
    }

    private static int calculateRealMaxCount(List<String> rawArguments, Range range, int routePosition) {
        int maxArguments = range.getMax() == Integer.MAX_VALUE ? rawArguments.size() : routePosition + range.getMax();
        return Math.min(maxArguments, rawArguments.size());
    }

    private int calculateMaxCount(Range range) {
        if (range.getMax() == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return range.getMax() + this.pivotPosition;
    }

    public class Context<SENDER, T> {
        private final Parser<SENDER, T> parser;
        private final Argument<T> argument;
        private final int argumentMinCount;
        private final int argumentMaxCount;
        private final int realArgumentMaxCount;
        private final int realArgumentMinCount;

        public Context(Argument<T> argument, Parser<SENDER, T> parser) {
            this.argument = argument;
            this.parser = parser;
            Range range = parser.getRange(argument);
            this.argumentMinCount = range.getMin() + RawInputAnalyzer.this.pivotPosition;
            this.argumentMaxCount = RawInputAnalyzer.this.calculateMaxCount(range);
            this.realArgumentMinCount = Math.min(this.argumentMinCount, RawInputAnalyzer.this.rawArguments.size());
            this.realArgumentMaxCount = RawInputAnalyzer.calculateRealMaxCount(RawInputAnalyzer.this.rawArguments, range, RawInputAnalyzer.this.pivotPosition);
        }

        public ParseResult<T> parseArgument(Invocation<SENDER> invocation) {
            List<String> arguments = RawInputAnalyzer.this.rawArguments.subList(RawInputAnalyzer.this.pivotPosition, this.realArgumentMaxCount);
            RawInput input = RawInput.of(arguments);
            ParseResult<T> parsed = this.parser.parse(invocation, this.argument, input);
            RawInputAnalyzer.this.pivotPosition = RawInputAnalyzer.this.pivotPosition + input.consumedCount();
            return parsed;
        }

        @ApiStatus.Experimental
        public boolean matchArgument(Invocation<SENDER> invocation) {
            List<String> arguments = RawInputAnalyzer.this.rawArguments.subList(RawInputAnalyzer.this.pivotPosition, this.realArgumentMaxCount);
            RawInput input = RawInput.of(arguments);
            boolean parse = this.parser.match(invocation, this.argument, input);
            RawInputAnalyzer.this.pivotPosition = RawInputAnalyzer.this.pivotPosition + input.consumedCount();
            return parse;
        }

        public boolean isLastArgument() {
            return RawInputAnalyzer.this.pivotPosition == RawInputAnalyzer.this.rawArguments.size() - 1 || this.realArgumentMaxCount >= RawInputAnalyzer.this.rawArguments.size() || this.isPotentialLastArgument() || RawInputAnalyzer.this.isLastOptionalArgument;
        }

        public boolean isMissingFullArgument() {
            return this.isNoMoreArguments() && this.isMissingPartOfArgument();
        }

        private boolean isNoMoreArguments() {
            return RawInputAnalyzer.this.pivotPosition >= RawInputAnalyzer.this.rawArguments.size();
        }

        public boolean isMissingPartOfArgument() {
            return this.argumentMinCount != this.realArgumentMinCount;
        }

        private boolean isPotentialLastArgument() {
            return this.realArgumentMaxCount < this.argumentMaxCount;
        }

        public List<String> getAllNotConsumedArguments() {
            return RawInputAnalyzer.this.rawArguments.subList(RawInputAnalyzer.this.pivotPosition, RawInputAnalyzer.this.rawArguments.size());
        }
    }
}

