/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache;

import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import com.google.errorprone.annotations.Var;

final class FrequencySketch {
    static final long RESET_MASK = 0x7777777777777777L;
    static final long ONE_MASK = 0x1111111111111111L;
    int sampleSize;
    int blockMask;
    long[] table;
    int size;

    public void ensureCapacity(long maximumSize) {
        Caffeine.requireArgument(maximumSize >= 0L);
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= maximum) {
            return;
        }
        this.table = new long[Math.max(Caffeine.ceilingPowerOfTwo(maximum), 8)];
        this.sampleSize = maximumSize == 0L ? 10 : 10 * maximum;
        this.blockMask = (this.table.length >>> 3) - 1;
        if (this.sampleSize <= 0) {
            this.sampleSize = Integer.MAX_VALUE;
        }
        this.size = 0;
    }

    public boolean isNotInitialized() {
        return this.table == null;
    }

    public int frequency(Object e) {
        if (this.isNotInitialized()) {
            return 0;
        }
        int frequency = Integer.MAX_VALUE;
        int blockHash = FrequencySketch.spread(e.hashCode());
        int counterHash = FrequencySketch.rehash(blockHash);
        int block = (blockHash & this.blockMask) << 3;
        for (int i = 0; i < 4; ++i) {
            int h = counterHash >>> (i << 3);
            int index = h >>> 1 & 0xF;
            int offset = h & 1;
            int slot = block + offset + (i << 1);
            int count = (int)(this.table[slot] >>> (index << 2) & 0xFL);
            frequency = Math.min(frequency, count);
        }
        return frequency;
    }

    public void increment(Object e) {
        if (this.isNotInitialized()) {
            return;
        }
        int blockHash = FrequencySketch.spread(e.hashCode());
        int counterHash = FrequencySketch.rehash(blockHash);
        int block = (blockHash & this.blockMask) << 3;
        int h0 = counterHash;
        int h1 = counterHash >>> 8;
        int h2 = counterHash >>> 16;
        int h3 = counterHash >>> 24;
        int index0 = h0 >>> 1 & 0xF;
        int index1 = h1 >>> 1 & 0xF;
        int index2 = h2 >>> 1 & 0xF;
        int index3 = h3 >>> 1 & 0xF;
        int slot0 = block + (h0 & 1);
        int slot1 = block + (h1 & 1) + 2;
        int slot2 = block + (h2 & 1) + 4;
        int slot3 = block + (h3 & 1) + 6;
        boolean added = this.incrementAt(slot0, index0) | this.incrementAt(slot1, index1) | this.incrementAt(slot2, index2) | this.incrementAt(slot3, index3);
        if (added && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    static int spread(@Var int x) {
        x ^= x >>> 17;
        x *= -312814405;
        x ^= x >>> 11;
        x *= -1404298415;
        x ^= x >>> 15;
        return x;
    }

    static int rehash(@Var int x) {
        x *= 830770091;
        x ^= x >>> 14;
        return x;
    }

    boolean incrementAt(int i, int j) {
        int offset = j << 2;
        long mask = 15L << offset;
        if ((this.table[i] & mask) != mask) {
            int n = i;
            this.table[n] = this.table[n] + (1L << offset);
            return true;
        }
        return false;
    }

    void reset() {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            count += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.size = this.size - (count >>> 2) >>> 1;
    }
}

