/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.fight.knockback;

import com.eternalcode.combat.fight.knockback.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.bukkit.Location;

class KnockbackOutsideRegionGenerator {
    KnockbackOutsideRegionGenerator() {
    }

    static Location generate(Point2D min, Point2D max, Location playerLocation) {
        NavigableMap<Double, List<Point2D>> points = KnockbackOutsideRegionGenerator.generatePoints(min, max, Point2D.from(playerLocation));
        TreeMap<Double, Double> distances = new TreeMap<Double, Double>();
        double totalWeight = 0.0;
        Double maxDistance = (Double)points.lastKey();
        Iterator iterator = points.keySet().iterator();
        while (iterator.hasNext()) {
            double distance = (Double)iterator.next();
            double weight = KnockbackOutsideRegionGenerator.createWeight(distance, maxDistance);
            distances.put(distance, weight);
            totalWeight += weight;
        }
        double rand = Math.random() * totalWeight;
        double cumulativeWeight = 0.0;
        for (Map.Entry entry : distances.entrySet()) {
            double distance = (Double)entry.getKey();
            double weight = (Double)entry.getValue();
            if (!(rand <= (cumulativeWeight += weight))) continue;
            return KnockbackOutsideRegionGenerator.getRandom((List)points.get(distance)).toLocation(playerLocation);
        }
        return KnockbackOutsideRegionGenerator.getRandom(points.firstEntry().getValue()).toLocation(playerLocation);
    }

    private static Point2D getRandom(List<Point2D> points) {
        return points.get((int)(Math.random() * (double)points.size()));
    }

    private static double createWeight(double distance, double maxDistance) {
        double last = Math.log(maxDistance);
        double weight = last - Math.log(distance);
        return Math.pow(weight, 10.0);
    }

    private static NavigableMap<Double, List<Point2D>> generatePoints(Point2D min, Point2D max, Point2D location) {
        int i;
        HashSet<Point2D> points = new HashSet<Point2D>();
        for (i = min.x() - 1; i <= max.x() + 1; ++i) {
            points.add(new Point2D(i, min.z() - 1));
            points.add(new Point2D(i, max.z() + 1));
        }
        for (i = min.z(); i <= max.z(); ++i) {
            points.add(new Point2D(min.x() - 1, i));
            points.add(new Point2D(max.x() + 1, i));
        }
        TreeMap<Double, List<Point2D>> result = new TreeMap<Double, List<Point2D>>();
        for (Point2D point : points) {
            double distance = KnockbackOutsideRegionGenerator.distance(location, point);
            result.computeIfAbsent(distance, k -> new ArrayList()).add(point);
        }
        return result;
    }

    private static double distance(Point2D p1, Point2D p2) {
        return Math.sqrt(Math.pow(p2.x() - p1.x(), 2.0) + Math.pow(p2.z() - p1.z(), 2.0));
    }
}

