/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border;

import com.eternalcode.combat.border.BorderPoint;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

class BorderActivePointsIndex {
    private final Map<String, Map<UUID, Set<BorderPoint>>> registry = new ConcurrentHashMap<String, Map<UUID, Set<BorderPoint>>>();

    BorderActivePointsIndex() {
    }

    boolean hasPoints(String world, UUID player) {
        Map<UUID, Set<BorderPoint>> worldRegistry = this.registry.get(world);
        if (worldRegistry == null) {
            return false;
        }
        return worldRegistry.containsKey(player);
    }

    Set<BorderPoint> putPoints(String world, UUID player, Set<BorderPoint> points) {
        Map worldRegistry = this.registry.computeIfAbsent(world, k -> new ConcurrentHashMap());
        Set<BorderPoint> oldPoints = worldRegistry.put(player, points);
        if (oldPoints != null) {
            return BorderActivePointsIndex.calculateRemovedPoints(points, oldPoints);
        }
        return Set.of();
    }

    private static Set<BorderPoint> calculateRemovedPoints(Set<BorderPoint> points, Set<BorderPoint> oldPoints) {
        HashSet<BorderPoint> removed = new HashSet<BorderPoint>();
        for (BorderPoint oldPoint : oldPoints) {
            if (points.contains(oldPoint)) continue;
            removed.add(oldPoint);
        }
        return Collections.unmodifiableSet(removed);
    }

    Set<BorderPoint> getPoints(String world, UUID player) {
        Map<UUID, Set<BorderPoint>> worldRegistry = this.registry.get(world);
        if (worldRegistry == null) {
            return Set.of();
        }
        return worldRegistry.getOrDefault(player, Set.of());
    }

    Set<BorderPoint> removePoints(String world, UUID player) {
        Map<UUID, Set<BorderPoint>> worldRegistry = this.registry.get(world);
        if (worldRegistry == null) {
            return Set.of();
        }
        Set<BorderPoint> remove = worldRegistry.remove(player);
        if (remove == null) {
            return Set.of();
        }
        return remove;
    }
}

