/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.Environment;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.AbstractMainThreadBasedScheduler;
import java.time.Duration;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitScheduler
extends AbstractMainThreadBasedScheduler {
    private final org.bukkit.scheduler.BukkitScheduler bukkitScheduler;
    private final Plugin plugin;

    public BukkitScheduler(Plugin plugin) {
        this(plugin.getServer().getScheduler(), plugin);
    }

    public BukkitScheduler(org.bukkit.scheduler.BukkitScheduler bukkitScheduler, Plugin plugin) {
        this.bukkitScheduler = bukkitScheduler;
        this.plugin = plugin;
        if (Environment.isFolia()) {
            plugin.getLogger().log(Level.WARNING, "[LiteCommands] Folia detected, but Folia extension is not enabled. To enable Folia support see https://docs.rollczi.dev/documentation/litecommands/extensions/folia.html");
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected void runSynchronous(Runnable task, Duration delay) {
        if (Bukkit.isPrimaryThread() && delay.isZero()) {
            task.run();
            return;
        }
        if (delay.isZero()) {
            this.bukkitScheduler.runTask(this.plugin, task);
        } else {
            this.bukkitScheduler.runTaskLater(this.plugin, task, this.toTicks(delay));
        }
    }

    @Override
    protected void runAsynchronous(Runnable task, Duration delay) {
        if (delay.isZero()) {
            this.bukkitScheduler.runTaskAsynchronously(this.plugin, task);
        } else {
            this.bukkitScheduler.runTaskLaterAsynchronously(this.plugin, task, this.toTicks(delay));
        }
    }

    @Override
    protected void log(Throwable throwable) {
        this.plugin.getLogger().log(Level.SEVERE, "An error occurred while executing a task", throwable);
    }

    private long toTicks(Duration duration) {
        return duration.toMillis() / 50L;
    }
}

