/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.block;

import com.eternalcode.combat.border.animation.block.BlockSettings;
import com.eternalcode.combat.border.animation.block.ChunkLocation;
import com.eternalcode.combat.libs.io.papermc.lib.PaperLib;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.CompletableFuture;
import org.bukkit.ChunkSnapshot;
import org.bukkit.entity.Player;

class ChunkCache {
    private final Cache<ChunkLocation, ChunkSnapshot> chunkCache;

    ChunkCache(BlockSettings settings) {
        this.chunkCache = CacheBuilder.newBuilder().expireAfterWrite(settings.chunkCacheDelay).build();
    }

    public ChunkSnapshot loadSnapshot(Player player, ChunkLocation location) {
        ChunkSnapshot snapshot = (ChunkSnapshot)this.chunkCache.getIfPresent((Object)location);
        if (snapshot != null) {
            return snapshot;
        }
        ChunkSnapshot chunkSnapshot = (ChunkSnapshot)((CompletableFuture)PaperLib.getChunkAtAsync(player.getWorld(), location.x(), location.z(), false).thenApply(chunk -> chunk.getChunkSnapshot())).join();
        this.chunkCache.put((Object)location, (Object)chunkSnapshot);
        return chunkSnapshot;
    }
}

