/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.serializer.experimental;

import com.eternalcode.combat.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.DeserializationData;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.SerializationData;
import com.eternalcode.combat.libs.org.yaml.snakeyaml.Yaml;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class CraftItemStackSerializer
implements ObjectSerializer<ItemStack> {
    private boolean verbose = false;

    @Override
    public boolean supports(@NonNull Class<? super ItemStack> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ItemStack.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull ItemStack stack, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        YamlConfiguration craftConfig = new YamlConfiguration();
        craftConfig.set("_", (Object)stack);
        String dump = craftConfig.saveToString();
        Map root = (Map)new Yaml().load(dump);
        Map itemMap = (Map)root.get("_");
        if (!this.verbose) {
            itemMap.remove("==");
        }
        itemMap.forEach(data::add);
    }

    @Override
    public ItemStack deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (data.getValueRaw() instanceof ItemStack) {
            return (ItemStack)data.getValueRaw();
        }
        LinkedHashMap<String, Object> itemMap = new LinkedHashMap<String, Object>();
        itemMap.put("==", "org.bukkit.inventory.ItemStack");
        itemMap.putAll(data.asMap());
        YamlConfiguration craftConfig = new YamlConfiguration();
        craftConfig.set("_", itemMap);
        String dump = craftConfig.saveToString();
        try {
            craftConfig.loadFromString(dump);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load ItemStack via bukkit [" + dump + "]", e);
        }
        return craftConfig.getItemStack("_");
    }

    public static boolean compareDeep(@NonNull ItemStack stack1, @NonNull ItemStack stack2) {
        if (stack1 == null) {
            throw new NullPointerException("stack1 is marked non-null but is null");
        }
        if (stack2 == null) {
            throw new NullPointerException("stack2 is marked non-null but is null");
        }
        YamlConfiguration config1 = new YamlConfiguration();
        config1.set("_", (Object)stack1);
        YamlConfiguration config2 = new YamlConfiguration();
        config2.set("_", (Object)stack2);
        return config1.saveToString().equals(config2.saveToString());
    }

    @Generated
    public CraftItemStackSerializer() {
    }

    @Generated
    public CraftItemStackSerializer(boolean verbose) {
        this.verbose = verbose;
    }
}

