/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.Scheduler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.SchedulerType;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.ThrowingSupplier;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SchedulerExecutorPoolImpl
implements Scheduler {
    public static final int CACHED_POOL = -1;
    private static final int MAIN_POOL_SIZE = 1;
    private static final String MAIN_THREAD_NAME_FORMAT = "scheduler-%s-main";
    private static final String ASYNC_THREAD_NAME_FORMAT = "scheduler-%s-async-%d";
    protected final ThreadLocal<Boolean> isMainThread = ThreadLocal.withInitial(() -> false);
    private final ExecutorService mainExecutor;
    private final ExecutorService asyncExecutor;
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());

    public SchedulerExecutorPoolImpl(String name) {
        this(name, -1);
    }

    public SchedulerExecutorPoolImpl(String name, int pool) {
        this.mainExecutor = this.createMainExecutor(name);
        this.asyncExecutor = this.createAsyncExecutor(name, pool);
    }

    @Override
    public <T> CompletableFuture<T> supplyLater(SchedulerType type, Duration delay, ThrowingSupplier<T, Throwable> supplier) {
        ExecutorService executor;
        SchedulerType resolve = type.resolve(SchedulerType.MAIN, SchedulerType.ASYNCHRONOUS).orElseThrow(() -> new IllegalStateException("Cannot resolve the thread type"));
        CompletableFuture future = new CompletableFuture();
        if (resolve.equals(SchedulerType.MAIN) && delay.isZero() && this.isMainThread.get().booleanValue()) {
            return SchedulerExecutorPoolImpl.tryRun(supplier, future);
        }
        ExecutorService executorService = executor = resolve.equals(SchedulerType.MAIN) ? this.mainExecutor : this.asyncExecutor;
        if (delay.isZero()) {
            executor.submit(() -> SchedulerExecutorPoolImpl.tryRun(supplier, future));
        } else {
            this.scheduledExecutor.schedule(() -> executor.submit(() -> SchedulerExecutorPoolImpl.tryRun(supplier, future)), delay.toMillis(), TimeUnit.MILLISECONDS);
        }
        return future;
    }

    private static <T> CompletableFuture<T> tryRun(ThrowingSupplier<T, Throwable> supplier, CompletableFuture<T> future) {
        try {
            future.complete(supplier.get());
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    @Override
    public void shutdown() {
        this.mainExecutor.shutdown();
        this.asyncExecutor.shutdown();
        this.isMainThread.remove();
    }

    protected ExecutorService createMainExecutor(String name) {
        ThreadFactory factory = runnable -> new Thread(() -> {
            this.isMainThread.set(true);
            runnable.run();
        }, String.format(MAIN_THREAD_NAME_FORMAT, name));
        ThreadPoolExecutor mainExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), factory);
        mainExecutor.allowCoreThreadTimeOut(true);
        return mainExecutor;
    }

    protected ExecutorService createAsyncExecutor(String name, int pool) {
        AtomicInteger asyncThreadCount = new AtomicInteger();
        ThreadFactory factory = runnable -> new Thread(runnable, String.format(ASYNC_THREAD_NAME_FORMAT, name, asyncThreadCount.getAndIncrement()));
        if (pool < 0) {
            return Executors.newCachedThreadPool(factory);
        }
        return new ThreadPoolExecutor(pool, pool, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), factory);
    }
}

