/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.permission;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.meta.MetaHolder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.PermissionValidationResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public class MissingPermissions
implements PermissionValidationResult {
    private final List<PermissionValidationResult.Verdict> verdicts;

    MissingPermissions(List<PermissionValidationResult.Verdict> verdicts) {
        this.verdicts = verdicts;
    }

    @Override
    @ApiStatus.Experimental
    public List<PermissionValidationResult.Verdict> getVerdicts() {
        return Collections.unmodifiableList(this.verdicts);
    }

    public List<String> getChecked() {
        return this.verdicts.stream().flatMap(result -> result.getChecks().stream()).flatMap(check -> check.getCheckedPermissions().stream()).distinct().collect(Collectors.toList());
    }

    public List<String> getPermissions() {
        return this.verdicts.stream().flatMap(result -> result.getChecks().stream()).flatMap(check -> check.getMissingPermissions().stream()).distinct().collect(Collectors.toList());
    }

    public String asJoinedText() {
        return this.asJoinedText(", ");
    }

    public String asJoinedText(String separator) {
        return String.join((CharSequence)separator, this.getPermissions());
    }

    public boolean isMissing() {
        return !this.isPermitted();
    }

    @Deprecated
    public static MissingPermissions missing(String ... permissions) {
        return new MissingPermissions(Collections.singletonList(new PermissionValidationResult.Verdict(MetaHolder.empty(), Collections.singletonList(new PermissionValidationResult.Check(Arrays.asList(permissions), Arrays.asList(permissions))))));
    }
}

