/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.folia;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.folia.FoliaSchedulerType;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.AbstractMainThreadBasedScheduler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.SchedulerType;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

class FoliaScheduler
extends AbstractMainThreadBasedScheduler {
    private final GlobalRegionScheduler globalScheduler;
    private final AsyncScheduler asyncScheduler;
    private final Plugin plugin;
    private final RegionScheduler regionScheduler;

    FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.regionScheduler = plugin.getServer().getRegionScheduler();
        this.globalScheduler = plugin.getServer().getGlobalRegionScheduler();
        this.asyncScheduler = plugin.getServer().getAsyncScheduler();
    }

    @Override
    public void shutdown() {
        this.globalScheduler.cancelTasks(this.plugin);
        this.asyncScheduler.cancelTasks(this.plugin);
    }

    @Override
    protected void runSynchronous(Runnable task, Duration delay) {
        if (this.plugin.getServer().isGlobalTickThread() && delay.isZero()) {
            task.run();
            return;
        }
        if (delay.isZero()) {
            this.globalScheduler.execute(this.plugin, task);
        } else {
            this.globalScheduler.runDelayed(this.plugin, scheduledTask -> task.run(), this.toTicks(delay));
        }
    }

    @Override
    protected void runAsynchronous(Runnable task, Duration delay) {
        if (delay.isZero()) {
            this.asyncScheduler.runNow(this.plugin, scheduledTask -> task.run());
        } else {
            this.asyncScheduler.runDelayed(this.plugin, scheduledTask -> task.run(), delay.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void log(Throwable throwable) {
        this.plugin.getLogger().log(Level.SEVERE, "An error occurred while executing a task", throwable);
    }

    private long toTicks(Duration duration) {
        return duration.toMillis() / 50L;
    }

    @Override
    protected boolean runUnknown(SchedulerType type, Duration delay, Runnable task) {
        if (!(type instanceof FoliaSchedulerType)) {
            return false;
        }
        FoliaSchedulerType foliaSchedulerType = (FoliaSchedulerType)type;
        Location location = foliaSchedulerType.getLocation();
        if (delay.isZero()) {
            this.regionScheduler.execute(this.plugin, location, task);
        } else {
            this.regionScheduler.runDelayed(this.plugin, location, scheduledTask -> task.run(), this.toTicks(delay));
        }
        return true;
    }
}

