/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.particle;

import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.BorderService;
import com.eternalcode.combat.border.animation.particle.ParticleSettings;
import com.eternalcode.combat.border.event.BorderHideAsyncEvent;
import com.eternalcode.combat.border.event.BorderShowAsyncEvent;
import com.eternalcode.combat.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ParticleController
implements Listener {
    private static final PacketEventsAPI<?> PACKET_EVENTS_API = PacketEvents.getAPI();
    private static final PlayerManager PLAYER_MANAGER = PACKET_EVENTS_API.getPlayerManager();
    private final BorderService borderService;
    private final Supplier<ParticleSettings> particleSettings;
    private final Server server;
    private final Set<UUID> playersToUpdate = ConcurrentHashMap.newKeySet();

    public ParticleController(BorderService borderService, Supplier<ParticleSettings> particleSettings, Scheduler scheduler, Server server) {
        this.borderService = borderService;
        this.particleSettings = particleSettings;
        this.server = server;
        scheduler.timerAsync(() -> this.updatePlayers(), Duration.ofMillis(200L), Duration.ofMillis(200L));
    }

    @EventHandler
    void onBorderShowAsyncEvent(BorderShowAsyncEvent event) {
        if (!this.particleSettings.get().enabled) {
            return;
        }
        this.playersToUpdate.add(event.getPlayer().getUniqueId());
        for (BorderPoint point : event.getPoints()) {
            this.playParticle(event.getPlayer(), point);
        }
    }

    @EventHandler
    void onBorderHideAsyncEvent(BorderHideAsyncEvent event) {
        if (!this.particleSettings.get().enabled) {
            return;
        }
        Set<BorderPoint> border = this.borderService.getActiveBorder(event.getPlayer());
        if (border.isEmpty()) {
            this.playersToUpdate.remove(event.getPlayer().getUniqueId());
        }
    }

    private void updatePlayers() {
        if (!this.particleSettings.get().enabled) {
            return;
        }
        for (UUID uuid : this.playersToUpdate) {
            Player player = this.server.getPlayer(uuid);
            if (player == null || !player.isOnline()) {
                this.playersToUpdate.remove(uuid);
                continue;
            }
            Set<BorderPoint> border = this.borderService.getActiveBorder(player);
            if (border.isEmpty()) {
                this.playersToUpdate.remove(uuid);
                continue;
            }
            for (BorderPoint point : border) {
                this.playParticle(player, point);
            }
        }
    }

    private void playParticle(Player player, BorderPoint point) {
        WrapperPlayServerParticle particle = this.particleSettings.get().getParticle(point);
        PLAYER_MANAGER.sendPacket((Object)player, (PacketWrapper)particle);
    }
}

