/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.type;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public interface TypeRange<T> {
    public boolean isInRange(Class<?> var1);

    public static <T> TypeRange<T> same(Class<T> type) {
        return new SameTypeRange<T>(type);
    }

    public static <T> TypeRange<T> upwards(Class<T> type) {
        return new UpwardsTypeRange<T>(type);
    }

    public static <T> TypeRange<T> downwards(Class<T> type) {
        return new DownwardsTypeRange<T>(type, Collections.emptySet());
    }

    public static <T> TypeRange<T> downwards(Class<T> type, Class<?> ... exclude) {
        return new DownwardsTypeRange<T>(type, new HashSet(Arrays.asList(exclude)));
    }

    public static <T> TypeRange<T> downwards(Class<T> type, Collection<Class<?>> exclude) {
        return new DownwardsTypeRange<T>(type, new HashSet(exclude));
    }

    public static class DownwardsTypeRange<T>
    implements TypeRange<T> {
        private final Class<T> type;
        private final Set<Class<?>> include;

        public DownwardsTypeRange(Class<T> type, Set<Class<?>> exclude) {
            this.type = type;
            this.include = DownwardsTypeRange.includedDownwards(exclude, new HashSet(), type);
        }

        public Set<Class<?>> getInclude() {
            return this.include;
        }

        @Override
        public boolean isInRange(Class<?> type) {
            return this.include.contains(type);
        }

        private static Set<Class<?>> includedDownwards(Set<Class<?>> exclude, Set<Class<?>> included, Class<?> type) {
            if (exclude.contains(type)) {
                return included;
            }
            included.add(type);
            Class<?> nextSuperType = type.getSuperclass();
            if (nextSuperType != null) {
                DownwardsTypeRange.includedDownwards(exclude, included, nextSuperType);
            }
            for (Class<?> anInterface : type.getInterfaces()) {
                DownwardsTypeRange.includedDownwards(exclude, included, anInterface);
            }
            return included;
        }
    }

    public static class UpwardsTypeRange<T>
    implements TypeRange<T> {
        private final Class<T> type;

        public UpwardsTypeRange(Class<T> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isInRange(Class<?> type) {
            return this.type.isAssignableFrom(type);
        }
    }

    public static class SameTypeRange<T>
    implements TypeRange<T> {
        private final Class<T> type;

        public SameTypeRange(Class<T> type) {
            this.type = type;
        }

        public Class<T> getSame() {
            return this.type;
        }

        @Override
        public boolean isInRange(Class<?> type) {
            return this.type == type;
        }
    }
}

