/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint.PrettyPrintAnnotation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint.PrettyPrintIndent;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint.PrettyPrintModifier;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint.PrettyPrintPicker;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint.PrettyPrintType;

public final class PrettyPrintClass {
    private static final String CLASS_KEYWORD = "class";
    private static final String INTERFACE_KEYWORD = "interface";
    private static final String ENUM_KEYWORD = "enum";
    private static final String ANNOTATION_KEYWORD = "@interface";
    private static final String CLASS_PATTERN = "{annotations}{modifiers}{keyword} {name}{generic} {\n{indentedContent}\n}";

    public static String formatClass(Class<?> classToFormat, PrettyPrintPicker picker, String content) {
        String annotations = PrettyPrintAnnotation.formatAnnotations(classToFormat.getAnnotations(), "\n", "\n");
        String modifiers = PrettyPrintModifier.formatModifiers(classToFormat.getModifiers());
        String keyword = PrettyPrintClass.formatKeyword(classToFormat);
        String name = classToFormat.getSimpleName();
        String generic = PrettyPrintType.formatGeneric(classToFormat.getTypeParameters());
        int additional = picker == PrettyPrintPicker.CLASS ? modifiers.length() + keyword.length() + " ".length() : 0;
        String indentedContent = PrettyPrintIndent.indentedContent(content, additional);
        return CLASS_PATTERN.replace("{annotations}", annotations).replace("{modifiers}", modifiers).replace("{keyword}", keyword).replace("{name}", name).replace("{generic}", generic).replace("{indentedContent}", indentedContent);
    }

    private static String formatKeyword(Class<?> clazz) {
        if (clazz.isInterface()) {
            return INTERFACE_KEYWORD;
        }
        if (clazz.isEnum()) {
            return ENUM_KEYWORD;
        }
        if (clazz.isAnnotation()) {
            return ANNOTATION_KEYWORD;
        }
        return CLASS_KEYWORD;
    }
}

