/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.context;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.context.ContextProvider;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.context.ContextResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.MessageRegistry;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class WorldContext
implements ContextProvider<CommandSender, World> {
    private final MessageRegistry<CommandSender> messageRegistry;

    public WorldContext(MessageRegistry<CommandSender> messageRegistry) {
        this.messageRegistry = messageRegistry;
    }

    @Override
    public ContextResult<World> provide(Invocation<CommandSender> invocation) {
        CommandSender sender = invocation.sender();
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return ContextResult.ok(() -> entity.getWorld());
        }
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender blockCommandSender = (BlockCommandSender)sender;
            return ContextResult.ok(() -> blockCommandSender.getBlock().getWorld());
        }
        return ContextResult.error(this.messageRegistry.get(LiteBukkitMessages.WORLD_NO_CONSOLE, invocation));
    }
}

