/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsException;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.TabComplete;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.ReflectUtil;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.Suggestion;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

class TabCompletePaper1_15Async
extends TabComplete
implements Listener {
    public TabCompletePaper1_15Async(Plugin plugin) {
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        pluginManager.registerEvent(PaperAsyncTabCompleteEvent.TAB_COMPLETE_CLASS, (Listener)this, EventPriority.HIGHEST, (listener, event) -> this.executeListener(event), plugin);
    }

    private void executeListener(Event event) {
        PaperAsyncTabCompleteEvent tabCompleteEvent = new PaperAsyncTabCompleteEvent(event);
        Set<Suggestion> result = this.callListener(tabCompleteEvent.getSender(), tabCompleteEvent.getBuffer());
        if (result == null) {
            return;
        }
        tabCompleteEvent.setCompletions(result.stream().map(suggestion -> suggestion.multilevel()).collect(Collectors.toList()));
    }

    @Override
    public void close() {
        super.close();
        HandlerList.unregisterAll((Listener)this);
    }

    static class PaperAsyncTabCompleteEvent {
        private static final String TAB_COMPLETE_CLASS_NAME = "com.destroystokyo.paper.event.server.AsyncTabCompleteEvent";
        static final Class<? extends Event> TAB_COMPLETE_CLASS = ReflectUtil.getClass("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent");
        static final Method GET_COMMAND_SENDER_METHOD = ReflectUtil.getMethod(TAB_COMPLETE_CLASS, "getSender", new Class[0]);
        static final Method GET_BUFFER_METHOD = ReflectUtil.getMethod(TAB_COMPLETE_CLASS, "getBuffer", new Class[0]);
        static final Method SET_COMPLETIONS_METHOD = ReflectUtil.getMethod(TAB_COMPLETE_CLASS, "setCompletions", List.class);
        private final Object event;

        PaperAsyncTabCompleteEvent(Object event) {
            if (!ReflectUtil.instanceOf(event, TAB_COMPLETE_CLASS)) {
                throw new LiteCommandsException("Event is not instance of com.destroystokyo.paper.event.server.AsyncTabCompleteEvent");
            }
            this.event = event;
        }

        public CommandSender getSender() {
            return (CommandSender)ReflectUtil.invokeMethod(GET_COMMAND_SENDER_METHOD, this.event, new Object[0]);
        }

        public String getBuffer() {
            return (String)ReflectUtil.invokeMethod(GET_BUFFER_METHOD, this.event, new Object[0]);
        }

        public void setCompletions(List<String> completions) {
            ReflectUtil.invokeMethod(SET_COMPLETIONS_METHOD, this.event, completions);
        }
    }
}

