/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.argument.profile;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.AnnotationInvoker;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.AnnotationProcessor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.MutableArgument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.profile.ArgumentProfile;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.LiteCommandsReflectInvocationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.jetbrains.annotations.Nullable;

public abstract class ProfileAnnotationProcessor<SENDER, A extends Annotation, PROFILE extends ArgumentProfile<PROFILE>>
implements AnnotationProcessor<SENDER> {
    private final Class<A> annotationType;

    protected ProfileAnnotationProcessor(Class<A> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public AnnotationInvoker<SENDER> process(AnnotationInvoker<SENDER> invoker) {
        return invoker.onParameterRequirement(this.annotationType, (parameter, annotation, builder, requirement) -> {
            if (!(requirement instanceof MutableArgument)) {
                Executable declaringExecutable = parameter.getDeclaringExecutable();
                throw new LiteCommandsReflectInvocationException(declaringExecutable, parameter, "@" + this.annotationType.getSimpleName() + " can be used only on arguments: " + requirement.getClass().getName());
            }
            MutableArgument argument = (MutableArgument)requirement;
            PROFILE profile = this.createProfile(parameter, annotation, argument);
            if (profile == null) {
                return;
            }
            argument.addProfile(profile);
        });
    }

    @Nullable
    protected abstract PROFILE createProfile(Parameter var1, A var2, Argument<?> var3);
}

