/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.eu.okaeri.configs.serdes.commons.serializer;

import com.eternalcode.combat.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.DeserializationData;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.SerializationData;
import java.math.BigDecimal;
import java.time.Instant;
import lombok.Generated;
import lombok.NonNull;

public class InstantSerializer
implements ObjectSerializer<Instant> {
    private final boolean numeric;

    @Override
    public boolean supports(@NonNull Class<? super Instant> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Instant.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull Instant object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (this.numeric) {
            data.setValue((Object)object.toEpochMilli(), Long.class);
        } else {
            data.setValue(object.toString());
        }
    }

    @Override
    public Instant deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String str = data.getValue(String.class);
        try {
            long epochMilli = new BigDecimal(str).longValueExact();
            return Instant.ofEpochMilli(epochMilli);
        }
        catch (NumberFormatException e) {
            return Instant.parse(str);
        }
    }

    @Generated
    public InstantSerializer(boolean numeric) {
        this.numeric = numeric;
    }
}

