/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.collector;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.collector.AbstractCollectorArgumentResolver;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.collector.VarargsProfile;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.type.TypeToken;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ArrayArgumentResolver<SENDER>
extends AbstractCollectorArgumentResolver<SENDER, Object> {
    public ArrayArgumentResolver(ParserRegistry<SENDER> parserRegistry, SuggesterRegistry<SENDER> suggesterRegistry) {
        super(parserRegistry, suggesterRegistry);
    }

    @Override
    <E> Collector<E, ?, Object> getCollector(VarargsProfile collectionArgument, Invocation<SENDER> invocation) {
        return new ArrayCollector(this.getElementType(collectionArgument));
    }

    @Override
    public boolean canParse(Argument<Object> argument, VarargsProfile collectionArgument) {
        return argument.getType().isArray();
    }

    private static class ArrayCollector<E>
    implements Collector<E, ArrayList<E>, Object> {
        private final TypeToken<E> componentType;

        private ArrayCollector(TypeToken<E> componentType) {
            this.componentType = componentType;
        }

        @Override
        public Supplier<ArrayList<E>> supplier() {
            return () -> new ArrayList();
        }

        @Override
        public BiConsumer<ArrayList<E>, E> accumulator() {
            return (objects, o) -> objects.add(o);
        }

        @Override
        public BinaryOperator<ArrayList<E>> combiner() {
            return (objects, objects2) -> {
                objects.addAll(objects2);
                return objects;
            };
        }

        @Override
        public Function<ArrayList<E>, Object> finisher() {
            return objects -> {
                Object array = Array.newInstance(this.componentType.getRawType(), objects.size());
                for (int i = 0; i < objects.size(); ++i) {
                    Array.set(array, i, objects.get(i));
                }
                return array;
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

