/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.prettyprint;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.StringJoiner;

final class PrettyPrintType {
    private static final String TYPE_PATTERN = "{name}{generic}";
    private static final String GENERIC_PATTERN = "<{types}>";

    PrettyPrintType() {
    }

    static String formatType(Type type) {
        String name = type.getTypeName();
        String generic = "";
        if (type instanceof Class) {
            Class clazz = (Class)type;
            name = clazz.getSimpleName();
            Type[] variables = clazz.getTypeParameters();
            if (variables.length > 0) {
                generic = PrettyPrintType.formatGeneric(variables);
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            name = ((Class)parameterizedType.getRawType()).getSimpleName();
            if (arguments.length > 0) {
                generic = PrettyPrintType.formatGeneric(arguments);
            }
        }
        return TYPE_PATTERN.replace("{name}", name).replace("{generic}", generic);
    }

    static String formatGeneric(Type[] types) {
        if (types.length == 0) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (Type type : types) {
            joiner.add(PrettyPrintType.formatType(type));
        }
        return GENERIC_PATTERN.replace("{types}", joiner.toString());
    }
}

