/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.meta;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.meta.MetaCollector;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.meta.MetaHolder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.meta.MetaKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class MetaHolderCollectorImpl
implements MetaCollector {
    private final MetaHolder metaHolder;

    MetaHolderCollectorImpl(MetaHolder metaHolder) {
        this.metaHolder = metaHolder;
    }

    @Override
    public <T> List<T> collect(MetaKey<T> key) {
        ArrayList<T> collected = new ArrayList<T>();
        for (MetaHolder current = this.metaHolder; current != null; current = current.parentMeta()) {
            if (!current.meta().has(key)) continue;
            collected.add(current.meta().get(key));
        }
        return collected;
    }

    @Override
    public <T> List<T> collectReverse(MetaKey<T> key) {
        ArrayList<T> collected = new ArrayList<T>();
        for (MetaHolder current = this.metaHolder; current != null; current = current.parentMeta()) {
            if (!current.meta().has(key)) continue;
            collected.add(0, current.meta().get(key));
        }
        return collected;
    }

    @Override
    public <T> Iterable<T> iterable(MetaKey<T> key) {
        return new MetaIterable(key);
    }

    @Override
    public <T> T findFirst(MetaKey<T> key) {
        T first = this.findFirst(key, null);
        if (first == null) {
            T defaultValue = key.getDefaultValue();
            if (defaultValue == null) {
                throw new NoSuchElementException("Meta value with key " + key.getKey() + " not found!");
            }
            return defaultValue;
        }
        return first;
    }

    @Override
    public <T> T findFirst(MetaKey<T> key, T defaultValue) {
        for (MetaHolder current = this.metaHolder; current != null; current = current.parentMeta()) {
            if (!current.meta().has(key)) continue;
            return current.meta().get(key);
        }
        return defaultValue;
    }

    @Override
    public <T> T findLast(MetaKey<T> key) {
        T last = this.findLast(key, null);
        if (last == null) {
            T defaultValue = key.getDefaultValue();
            if (defaultValue == null) {
                throw new NoSuchElementException("Meta value with key " + key.getKey() + " not found!");
            }
            return defaultValue;
        }
        return last;
    }

    @Override
    public <T> T findLast(MetaKey<T> key, T defaultValue) {
        Object last = null;
        for (MetaHolder current = this.metaHolder; current != null; current = current.parentMeta()) {
            if (!current.meta().has(key)) continue;
            last = current.meta().get(key);
        }
        return (T)(last == null ? defaultValue : last);
    }

    private class MetaIterator<T>
    implements Iterator<T> {
        private final MetaKey<T> key;
        private MetaHolder current;
        private T next;

        private MetaIterator(MetaKey<T> key) {
            this.current = MetaHolderCollectorImpl.this.metaHolder;
            this.key = key;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements to iterate!");
            }
            T next = this.next;
            this.findNext();
            return next;
        }

        private void findNext() {
            while (this.current != null) {
                Object t = this.current.meta().get(this.key, null);
                if (t != null) {
                    this.next = t;
                    this.current = this.current.parentMeta();
                    return;
                }
                this.current = this.current.parentMeta();
            }
            this.next = null;
        }
    }

    private class MetaIterable<T>
    implements Iterable<T> {
        private final MetaKey<T> key;

        private MetaIterable(MetaKey<T> key) {
            this.key = key;
        }

        @Override
        public Iterator<T> iterator() {
            return new MetaIterator(this.key);
        }
    }
}

