/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.message;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.InvokedMessage;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.Message;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.MessageKey;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MessageRegistry<SENDER> {
    private final Map<MessageKey<?>, Message<?, ?>> messages = new HashMap();
    private final Map<MessageKey<?>, InvokedMessage<SENDER, ?, ?>> invokedMessages = new HashMap();

    public <T, CONTEXT> void register(MessageKey<CONTEXT> key, Message<T, CONTEXT> message) {
        this.messages.put(key, message);
    }

    public <T, CONTEXT> void register(MessageKey<CONTEXT> key, InvokedMessage<SENDER, T, CONTEXT> message) {
        this.invokedMessages.put(key, message);
    }

    public Object get(MessageKey<Void> key, Invocation<SENDER> invocation) {
        return this.get(key, invocation, null);
    }

    public <CONTEXT> Object get(MessageKey<CONTEXT> key, Invocation<SENDER> invocation, CONTEXT context) {
        Object invokedMessage = this.getRegisteredMessage(key, invocation, context);
        if (invokedMessage != null) {
            return invokedMessage;
        }
        for (MessageKey<CONTEXT> fallback : key.getFallbacks()) {
            Object fallbackMessage = this.getRegisteredMessage(fallback, invocation, context);
            if (fallbackMessage == null) continue;
            return fallbackMessage;
        }
        return key.getDefaultMessage(context);
    }

    @Nullable
    private <CONTEXT> Object getRegisteredMessage(MessageKey<CONTEXT> key, Invocation<SENDER> invocation, CONTEXT context) {
        InvokedMessage<SENDER, ?, ?> invokedMessage = this.invokedMessages.get(key);
        if (invokedMessage != null) {
            return invokedMessage.get(invocation, context);
        }
        Message<?, ?> message = this.messages.get(key);
        if (message != null) {
            return message.get(context);
        }
        return null;
    }
}

