/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.folia;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsBuilder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.LiteCommandsInternal;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.BukkitScheduler;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.Environment;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.configurator.LiteConfigurator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.extension.LiteExtension;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.folia.FoliaInternalExtension;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scheduler.Scheduler;
import java.util.function.Supplier;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class FoliaExtension
implements LiteExtension<CommandSender, Settings> {
    private final Settings settings;
    private final Plugin plugin;

    public FoliaExtension(Plugin plugin) {
        this.plugin = plugin;
        this.settings = new Settings(true, () -> new BukkitScheduler(plugin));
    }

    @Override
    public void configure(LiteConfigurator<Settings> configurer) {
        configurer.configure(this.settings);
    }

    @Override
    public void extend(LiteCommandsBuilder<CommandSender, ?, ?> builder, LiteCommandsInternal<CommandSender, ?> internal) {
        if (Environment.isFolia()) {
            FoliaInternalExtension.enableFoliaSupport(this.plugin, builder, this.settings.useRegionSchedulerIfAvailable);
            return;
        }
        this.fallback(builder);
    }

    private void fallback(LiteCommandsBuilder<CommandSender, ?, ?> builder) {
        if (this.settings.fallbackScheduler != null) {
            builder.scheduler(this.settings.fallbackScheduler.get());
        }
    }

    public record Settings(boolean useRegionSchedulerIfAvailable, @Nullable Supplier<Scheduler> fallbackScheduler) {
        public Settings fallbackScheduler(Supplier<Scheduler> fallbackScheduler) {
            return new Settings(this.useRegionSchedulerIfAvailable, fallbackScheduler);
        }
    }
}

