/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.cooldown;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.executor.CommandExecuteResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.executor.event.CommandPostExecutionEvent;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.executor.event.CommandPreExecutionEvent;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.cooldown.CooldownService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.cooldown.CooldownState;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.event.EventListener;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.event.Subscriber;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.platform.PlatformSender;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.shared.FailedReason;
import java.util.Optional;

public class CooldownStateController<SENDER>
implements EventListener {
    private final CooldownService cooldownService;

    public CooldownStateController(CooldownService cooldownService) {
        this.cooldownService = cooldownService;
    }

    @Subscriber
    public void onEvent(CommandPreExecutionEvent<SENDER> event) {
        Invocation<SENDER> invocation = event.getInvocation();
        PlatformSender sender = invocation.platformSender();
        Optional<CooldownState> currentState = this.cooldownService.getCooldown(event.getExecutor(), sender);
        if (currentState.isPresent()) {
            event.cancel(FailedReason.of(currentState.get()));
        }
    }

    @Subscriber
    public void onEvent(CommandPostExecutionEvent<SENDER> event) {
        CommandExecuteResult result = event.getResult();
        if (!result.isSuccessful()) {
            return;
        }
        this.cooldownService.markCooldown(event.getInvocation(), event.getExecutor());
    }
}

