/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.argument;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.message.MessageRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerArgument
extends ArgumentResolver<CommandSender, Player> {
    private final Server server;
    private final MessageRegistry<CommandSender> messageRegistry;

    public PlayerArgument(Server server, MessageRegistry<CommandSender> messageRegistry) {
        this.server = server;
        this.messageRegistry = messageRegistry;
    }

    @Override
    protected ParseResult<Player> parse(Invocation<CommandSender> invocation, Argument<Player> context, String argument) {
        Player player = this.server.getPlayer(argument);
        if (player != null) {
            return ParseResult.success(player);
        }
        return ParseResult.failure(this.messageRegistry.get(LiteBukkitMessages.PLAYER_NOT_FOUND, invocation, argument));
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Player> argument, SuggestionContext context) {
        return (SuggestionResult)this.server.getOnlinePlayers().stream().collect(SuggestionResult.collector(player -> player.getName(), player -> player.getUniqueId().toString()));
    }
}

