/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache;

import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Node;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Pacer;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.SSLMS;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Scheduler;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.Ticker;
import com.eternalcode.combat.libs.com.github.benmanes.caffeine.cache.WriteOrderDeque;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

class SSLMSW<K, V>
extends SSLMS<K, V> {
    static final LocalCacheFactory FACTORY = SSLMSW::new;
    protected static final VarHandle EXPIRES_AFTER_WRITE_NANOS;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SSLMSW(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.setExpiresAfterWriteNanos(caffeine.getExpiresAfterWriteNanos());
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return EXPIRES_AFTER_WRITE_NANOS.getAcquire(this);
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        EXPIRES_AFTER_WRITE_NANOS.setRelease(this, l);
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            EXPIRES_AFTER_WRITE_NANOS = lookup.findVarHandle(SSLMSW.class, "expiresAfterWriteNanos", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

