/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver;

import com.eternalcode.combat.libs.com.eternalcode.multification.notice.NoticeKey;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.NoticePart;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.NoticeContent;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.NoticeDeserializeResult;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.NoticeResolver;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.NoticeSerdesResult;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.text.TextContent;
import com.eternalcode.combat.libs.com.eternalcode.multification.notice.resolver.text.TextContentResolver;
import com.eternalcode.combat.libs.net.kyori.adventure.audience.Audience;
import com.eternalcode.combat.libs.net.kyori.adventure.text.Component;
import com.eternalcode.combat.libs.net.kyori.adventure.text.serializer.ComponentSerializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public class NoticeResolverRegistry {
    private final Map<NoticeKey<?>, NoticeResolver<?>> resolvers = new HashMap();
    private final Map<String, Set<NoticeResolver<?>>> resolversByKey = new HashMap();

    public <T extends NoticeContent> NoticeResolverRegistry registerResolver(NoticeResolver<T> resolver) {
        this.resolvers.put(resolver.noticeKey(), resolver);
        this.resolversByKey.computeIfAbsent(resolver.noticeKey().key(), key -> new HashSet()).add(resolver);
        return this;
    }

    public <T extends NoticeContent> NoticeSerdesResult serialize(NoticePart<T> noticePart) {
        NoticeResolver<T> resolver = this.getNoticeResolverOrThrow(noticePart.noticeKey());
        return resolver.serialize(noticePart.content());
    }

    public Optional<NoticeDeserializeResult<?>> deserialize(String key, NoticeSerdesResult result) {
        Set<NoticeResolver<?>> resolvers = this.resolversByKey.get(key);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not deserialize " + String.valueOf(result));
        for (NoticeResolver<?> resolver : resolvers) {
            try {
                NoticeDeserializeResult<?> deserializeResult = this.deserialize(resolver, result);
                if (deserializeResult == null) continue;
                return Optional.of(deserializeResult);
            }
            catch (Throwable exception) {
                illegalArgumentException.addSuppressed(exception);
            }
        }
        if (illegalArgumentException.getSuppressed().length > 0) {
            throw illegalArgumentException;
        }
        return Optional.empty();
    }

    @Nullable
    private <T extends NoticeContent> NoticeDeserializeResult<T> deserialize(NoticeResolver<T> resolver, NoticeSerdesResult result) {
        return resolver.deserialize(result).map(content -> new NoticeDeserializeResult<NoticeContent>(resolver.noticeKey(), (NoticeContent)content)).orElse(null);
    }

    public <T extends NoticeContent> void send(Audience audience, ComponentSerializer<Component, Component, String> serializer, NoticePart<T> noticePart) {
        NoticeResolver<T> resolver = this.getNoticeResolverOrThrow(noticePart.noticeKey());
        resolver.send(audience, serializer, noticePart.content());
    }

    private <T extends NoticeContent> NoticeResolver<T> getNoticeResolverOrThrow(NoticeKey<T> key) {
        NoticeResolver<?> resolver = this.resolvers.get(key);
        if (resolver == null) {
            throw new IllegalArgumentException("No resolver found for " + String.valueOf(key) + " - " + String.valueOf(key));
        }
        return resolver;
    }

    public <T extends TextContent> T createTextNotice(NoticeKey<T> noticeKey, List<String> contents) {
        NoticeResolver<T> resolver = this.getNoticeResolverOrThrow(noticeKey);
        if (!(resolver instanceof TextContentResolver)) {
            throw new IllegalArgumentException("Resolver for " + String.valueOf(noticeKey) + " is not a text resolver");
        }
        TextContentResolver textContentResolver = (TextContentResolver)resolver;
        return textContentResolver.createFromText(contents);
    }

    public <T extends TextContent> NoticePart<T> applyText(NoticePart<T> part, UnaryOperator<String> function) {
        NoticeResolver<T> resolver = this.getNoticeResolverOrThrow(part.noticeKey());
        if (resolver instanceof TextContentResolver) {
            TextContentResolver textContentResolver = (TextContentResolver)resolver;
            TextContent t = textContentResolver.applyText((TextContent)part.content(), function);
            return new NoticePart<TextContent>(part.noticeKey(), t);
        }
        return part;
    }
}

