/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.fight;

import com.eternalcode.combat.fight.FightTag;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class FightTagImpl
implements FightTag {
    private final UUID taggedPlayer;
    private final Instant endOfCombatLog;
    @Nullable
    private final UUID tagger;

    FightTagImpl(UUID personToAddCombat, Instant endOfCombatLog, @Nullable UUID tagger) {
        this.taggedPlayer = personToAddCombat;
        this.endOfCombatLog = endOfCombatLog;
        this.tagger = tagger;
    }

    @Override
    public UUID getTaggedPlayer() {
        return this.taggedPlayer;
    }

    @Override
    public Instant getEndOfCombatLog() {
        return this.endOfCombatLog;
    }

    @Override
    public boolean isExpired() {
        return Instant.now().isAfter(this.endOfCombatLog);
    }

    @Override
    public Duration getRemainingDuration() {
        Duration between = Duration.between(Instant.now(), this.endOfCombatLog);
        if (between.isNegative()) {
            return Duration.ZERO;
        }
        return between;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public UUID getTagger() {
        return this.tagger;
    }
}

