/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.fight;

import com.eternalcode.combat.config.implementation.MessagesSettings;
import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.fight.FightManager;
import com.eternalcode.combat.fight.FightTag;
import com.eternalcode.combat.fight.event.CancelTagReason;
import com.eternalcode.combat.fight.event.CauseOfTag;
import com.eternalcode.combat.fight.event.CauseOfUnTag;
import com.eternalcode.combat.fight.event.FightTagEvent;
import com.eternalcode.combat.fight.event.FightUntagEvent;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.priority.Priority;
import com.eternalcode.combat.notification.NoticeService;
import java.time.Duration;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="combatlog", aliases={"combat"})
public class FightTagCommand {
    private final FightManager fightManager;
    private final NoticeService noticeService;
    private final PluginConfig config;

    public FightTagCommand(FightManager fightManager, NoticeService noticeService, PluginConfig config) {
        this.fightManager = fightManager;
        this.noticeService = noticeService;
        this.config = config;
    }

    @Execute(name="status")
    @Permission(value={"eternalcombat.status"})
    void status(@Context CommandSender sender, @Arg Player target) {
        UUID targetUniqueId = target.getUniqueId();
        this.noticeService.create().notice(this.fightManager.isInCombat(targetUniqueId) ? this.config.messagesSettings.admin.playerInCombat : this.config.messagesSettings.admin.playerNotInCombat).placeholder("{PLAYER}", target.getName()).viewer((CommandSender)sender).send();
    }

    @Execute(name="tag")
    @Permission(value={"eternalcombat.tag"})
    @Priority(value=100)
    void tag(@Context CommandSender sender, @Arg Player target) {
        Duration time;
        UUID targetUniqueId = target.getUniqueId();
        FightTagEvent event = this.fightManager.tag(targetUniqueId, time = this.config.settings.combatTimerDuration, CauseOfTag.COMMAND);
        if (event.isCancelled()) {
            CancelTagReason cancelReason = event.getCancelReason();
            this.tagoutReasonHandler(sender, cancelReason, this.config.messagesSettings);
            return;
        }
        this.noticeService.create().notice(this.config.messagesSettings.admin.adminTagPlayer).placeholder("{PLAYER}", target.getName()).viewer((CommandSender)sender).send();
    }

    @Execute(name="tag")
    @Permission(value={"eternalcombat.tag"})
    void tagMultiple(@Context CommandSender sender, @Arg Player firstTarget, @Arg Player secondTarget) {
        Duration combatTime = this.config.settings.combatTimerDuration;
        MessagesSettings messagesSettings = this.config.messagesSettings;
        if (sender.equals((Object)firstTarget) || sender.equals((Object)secondTarget)) {
            this.noticeService.create().notice(messagesSettings.admin.adminCannotTagSelf).viewer((CommandSender)sender).send();
            return;
        }
        FightTagEvent firstTagEvent = this.fightManager.tag(firstTarget.getUniqueId(), combatTime, CauseOfTag.COMMAND);
        FightTagEvent secondTagEvent = this.fightManager.tag(secondTarget.getUniqueId(), combatTime, CauseOfTag.COMMAND);
        if (firstTagEvent.isCancelled()) {
            CancelTagReason cancelReason = firstTagEvent.getCancelReason();
            this.tagoutReasonHandler(sender, cancelReason, messagesSettings);
            return;
        }
        if (secondTagEvent.isCancelled()) {
            CancelTagReason cancelReason = secondTagEvent.getCancelReason();
            this.tagoutReasonHandler(sender, cancelReason, messagesSettings);
            return;
        }
        if (firstTagEvent.isCancelled() && secondTagEvent.isCancelled()) {
            return;
        }
        this.noticeService.create().notice(messagesSettings.admin.adminTagMultiplePlayers).placeholder("{FIRST_PLAYER}", firstTarget.getName()).placeholder("{SECOND_PLAYER}", secondTarget.getName()).viewer((CommandSender)sender).send();
    }

    @Execute(name="untag")
    @Permission(value={"eternalcombat.untag"})
    void untag(@Context CommandSender sender, @Arg Player target) {
        UUID targetUniqueId = target.getUniqueId();
        if (!this.fightManager.isInCombat(targetUniqueId)) {
            this.noticeService.create().notice(this.config.messagesSettings.admin.adminPlayerNotInCombat).placeholder("{PLAYER}", target.getName()).viewer((CommandSender)sender).send();
            return;
        }
        FightUntagEvent event = this.fightManager.untag(targetUniqueId, CauseOfUnTag.COMMAND);
        if (event.isCancelled()) {
            return;
        }
        this.noticeService.create().notice(this.config.messagesSettings.admin.adminUntagPlayer).placeholder("{PLAYER}", target.getName()).viewer((CommandSender)sender).send();
    }

    @Execute(name="untagall")
    @Permission(value={"eternalcombat.untagall"})
    void untagAll(@Context CommandSender sender) {
        int combatPlayersSize = this.fightManager.getFights().size();
        this.fightManager.getFights().stream().map(FightTag::getTaggedPlayer).collect(Collectors.toSet()).forEach(uuid -> this.fightManager.untag((UUID)uuid, CauseOfUnTag.COMMAND));
        this.noticeService.create().notice(this.config.messagesSettings.admin.adminUntagAll).placeholder("{COUNT}", String.valueOf(combatPlayersSize)).viewer((CommandSender)sender).send();
    }

    private void tagoutReasonHandler(CommandSender sender, CancelTagReason cancelReason, MessagesSettings messagesSettings) {
        if (cancelReason == CancelTagReason.TAGOUT) {
            this.noticeService.create().notice(messagesSettings.admin.adminTagOutCanceled).viewer((CommandSender)sender).send();
        }
    }
}

