/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.block;

import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.animation.BorderColorUtil;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.DyeColor;

final class BorderBlockRainbowUtil {
    private static final Map<DyeColor, StateType> GLASSES = new EnumMap<DyeColor, StateType>((Map<DyeColor, StateType>)ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)StateTypes.WHITE_STAINED_GLASS).put((Object)DyeColor.ORANGE, (Object)StateTypes.ORANGE_STAINED_GLASS).put((Object)DyeColor.MAGENTA, (Object)StateTypes.MAGENTA_STAINED_GLASS).put((Object)DyeColor.LIGHT_BLUE, (Object)StateTypes.LIGHT_BLUE_STAINED_GLASS).put((Object)DyeColor.YELLOW, (Object)StateTypes.YELLOW_STAINED_GLASS).put((Object)DyeColor.LIME, (Object)StateTypes.LIME_STAINED_GLASS).put((Object)DyeColor.PINK, (Object)StateTypes.PINK_STAINED_GLASS).put((Object)DyeColor.GRAY, (Object)StateTypes.GRAY_STAINED_GLASS).put((Object)DyeColor.LIGHT_GRAY, (Object)StateTypes.LIGHT_GRAY_STAINED_GLASS).put((Object)DyeColor.CYAN, (Object)StateTypes.CYAN_STAINED_GLASS).put((Object)DyeColor.PURPLE, (Object)StateTypes.PURPLE_STAINED_GLASS).put((Object)DyeColor.BLUE, (Object)StateTypes.BLUE_STAINED_GLASS).put((Object)DyeColor.BROWN, (Object)StateTypes.BROWN_STAINED_GLASS).put((Object)DyeColor.GREEN, (Object)StateTypes.GREEN_STAINED_GLASS).put((Object)DyeColor.RED, (Object)StateTypes.RED_STAINED_GLASS).build());
    private static final Map<DyeColor, StateType> TERRACOTTA = new EnumMap<DyeColor, StateType>((Map<DyeColor, StateType>)ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)StateTypes.WHITE_TERRACOTTA).put((Object)DyeColor.ORANGE, (Object)StateTypes.ORANGE_TERRACOTTA).put((Object)DyeColor.MAGENTA, (Object)StateTypes.MAGENTA_TERRACOTTA).put((Object)DyeColor.LIGHT_BLUE, (Object)StateTypes.LIGHT_BLUE_TERRACOTTA).put((Object)DyeColor.YELLOW, (Object)StateTypes.YELLOW_TERRACOTTA).put((Object)DyeColor.LIME, (Object)StateTypes.LIME_TERRACOTTA).put((Object)DyeColor.PINK, (Object)StateTypes.PINK_TERRACOTTA).put((Object)DyeColor.GRAY, (Object)StateTypes.GRAY_TERRACOTTA).put((Object)DyeColor.LIGHT_GRAY, (Object)StateTypes.LIGHT_GRAY_TERRACOTTA).put((Object)DyeColor.CYAN, (Object)StateTypes.CYAN_TERRACOTTA).put((Object)DyeColor.PURPLE, (Object)StateTypes.PURPLE_TERRACOTTA).put((Object)DyeColor.BLUE, (Object)StateTypes.BLUE_TERRACOTTA).put((Object)DyeColor.BROWN, (Object)StateTypes.BROWN_TERRACOTTA).put((Object)DyeColor.GREEN, (Object)StateTypes.GREEN_TERRACOTTA).put((Object)DyeColor.RED, (Object)StateTypes.RED_TERRACOTTA).build());
    private static final Map<DyeColor, StateType> WOOLS = new EnumMap<DyeColor, StateType>((Map<DyeColor, StateType>)ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)StateTypes.WHITE_WOOL).put((Object)DyeColor.ORANGE, (Object)StateTypes.ORANGE_WOOL).put((Object)DyeColor.MAGENTA, (Object)StateTypes.MAGENTA_WOOL).put((Object)DyeColor.LIGHT_BLUE, (Object)StateTypes.LIGHT_BLUE_WOOL).put((Object)DyeColor.YELLOW, (Object)StateTypes.YELLOW_WOOL).put((Object)DyeColor.LIME, (Object)StateTypes.LIME_WOOL).put((Object)DyeColor.PINK, (Object)StateTypes.PINK_WOOL).put((Object)DyeColor.GRAY, (Object)StateTypes.GRAY_WOOL).put((Object)DyeColor.LIGHT_GRAY, (Object)StateTypes.LIGHT_GRAY_WOOL).put((Object)DyeColor.CYAN, (Object)StateTypes.CYAN_WOOL).put((Object)DyeColor.PURPLE, (Object)StateTypes.PURPLE_WOOL).put((Object)DyeColor.BLUE, (Object)StateTypes.BLUE_WOOL).put((Object)DyeColor.BROWN, (Object)StateTypes.BROWN_WOOL).put((Object)DyeColor.GREEN, (Object)StateTypes.GREEN_WOOL).put((Object)DyeColor.RED, (Object)StateTypes.RED_WOOL).build());
    private static final Map<DyeColor, StateType> CONCRETE = new EnumMap<DyeColor, StateType>((Map<DyeColor, StateType>)ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)StateTypes.WHITE_CONCRETE).put((Object)DyeColor.ORANGE, (Object)StateTypes.ORANGE_CONCRETE).put((Object)DyeColor.MAGENTA, (Object)StateTypes.MAGENTA_CONCRETE).put((Object)DyeColor.LIGHT_BLUE, (Object)StateTypes.LIGHT_BLUE_CONCRETE).put((Object)DyeColor.YELLOW, (Object)StateTypes.YELLOW_CONCRETE).put((Object)DyeColor.LIME, (Object)StateTypes.LIME_CONCRETE).put((Object)DyeColor.PINK, (Object)StateTypes.PINK_CONCRETE).put((Object)DyeColor.GRAY, (Object)StateTypes.GRAY_CONCRETE).put((Object)DyeColor.LIGHT_GRAY, (Object)StateTypes.LIGHT_GRAY_CONCRETE).put((Object)DyeColor.CYAN, (Object)StateTypes.CYAN_CONCRETE).put((Object)DyeColor.PURPLE, (Object)StateTypes.PURPLE_CONCRETE).put((Object)DyeColor.BLUE, (Object)StateTypes.BLUE_CONCRETE).put((Object)DyeColor.BROWN, (Object)StateTypes.BROWN_CONCRETE).put((Object)DyeColor.GREEN, (Object)StateTypes.GREEN_CONCRETE).put((Object)DyeColor.RED, (Object)StateTypes.RED_CONCRETE).build());

    BorderBlockRainbowUtil() {
    }

    static StateType xyzToGlass(BorderPoint point) {
        return GLASSES.get(BorderBlockRainbowUtil.xyzToDye(point));
    }

    static StateType xyzToTerracotta(BorderPoint point) {
        return TERRACOTTA.get(BorderBlockRainbowUtil.xyzToDye(point));
    }

    public static StateType xyzToWool(BorderPoint point) {
        return WOOLS.get(BorderBlockRainbowUtil.xyzToDye(point));
    }

    public static StateType xyzToConcrete(BorderPoint point) {
        return CONCRETE.get(BorderBlockRainbowUtil.xyzToDye(point));
    }

    private static DyeColor xyzToDye(BorderPoint point) {
        Color rgb = BorderColorUtil.xyzToRainbow(point.x(), point.y(), point.z());
        int distance = Integer.MAX_VALUE;
        DyeColor dye = DyeColor.WHITE;
        for (DyeColor currentDye : DyeColor.values()) {
            org.bukkit.Color color = currentDye.getColor();
            int currentDistance = Math.abs(color.getRed() - rgb.getRed()) + Math.abs(color.getGreen() - rgb.getGreen()) + Math.abs(color.getBlue() - rgb.getBlue());
            if (currentDistance >= distance) continue;
            distance = currentDistance;
            dye = currentDye;
        }
        return dye;
    }
}

