/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.block;

import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.animation.block.BorderBlockRainbowUtil;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import java.util.Locale;

public class BlockType {
    public static final BlockType RAINBOW_GLASS = new BlockType("RAINBOW_GLASS", point -> BorderBlockRainbowUtil.xyzToGlass(point));
    public static final BlockType RAINBOW_TERRACOTTA = new BlockType("RAINBOW_TERRACOTTA", point -> BorderBlockRainbowUtil.xyzToTerracotta(point));
    public static final BlockType RAINBOW_WOOL = new BlockType("RAINBOW_WOOL", point -> BorderBlockRainbowUtil.xyzToWool(point));
    public static final BlockType RAINBOW_CONCRETE = new BlockType("RAINBOW_CONCRETE", point -> BorderBlockRainbowUtil.xyzToConcrete(point));
    private final String name;
    private final TypeProvider type;

    private BlockType(String name, TypeProvider type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public StateType getStateType(BorderPoint point) {
        return this.type.provide(point);
    }

    public static BlockType fromName(String name) {
        return switch (name) {
            case "RAINBOW_GLASS" -> RAINBOW_GLASS;
            case "RAINBOW_WOOL" -> RAINBOW_WOOL;
            case "RAINBOW_TERRACOTTA" -> RAINBOW_TERRACOTTA;
            case "RAINBOW_CONCRETE" -> RAINBOW_CONCRETE;
            default -> new BlockType(name, point -> StateTypes.getByName((String)name.toLowerCase(Locale.ROOT)));
        };
    }

    private static interface TypeProvider {
        public StateType provide(BorderPoint var1);
    }
}

