/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.region;

import com.eternalcode.combat.region.Region;
import com.eternalcode.combat.region.RegionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;

public class CompositeRegionProvider
implements RegionProvider {
    private final List<RegionProvider> providers;

    public CompositeRegionProvider(List<RegionProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Optional<Region> getRegion(Location location) {
        for (RegionProvider provider : this.providers) {
            Optional<Region> region = provider.getRegion(location);
            if (!region.isPresent()) continue;
            return region;
        }
        return Optional.empty();
    }

    @Override
    public Collection<Region> getRegions(World world) {
        ArrayList<Region> combined = new ArrayList<Region>();
        for (RegionProvider provider : this.providers) {
            combined.addAll(provider.getRegions(world));
        }
        return combined;
    }
}

