/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.Parser;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandRoute;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.permission.PermissionService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.range.Range;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.Schematic;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicFormat;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicFormatProvider;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicGenerator;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.schematic.SchematicInput;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleSchematicGenerator<SENDER>
implements SchematicGenerator<SENDER>,
SchematicFormatProvider {
    private static final String SEPARATOR = " ";
    protected final SchematicFormat format;
    protected final PermissionService permissionService;
    protected final ParserRegistry<SENDER> parserRegistry;

    public SimpleSchematicGenerator(SchematicFormat format, PermissionService permissionService, ParserRegistry<SENDER> parserRegistry) {
        this.format = format;
        this.permissionService = permissionService;
        this.parserRegistry = parserRegistry;
    }

    @Override
    public Schematic generate(SchematicInput<SENDER> schematicInput) {
        List<String> schematics = this.generateRaw(schematicInput).map(schematic -> this.format.prefix() + schematic.trim() + this.format.suffix()).distinct().collect(Collectors.toList());
        return new Schematic(schematics);
    }

    @Override
    public SchematicFormat getFormat() {
        return this.format;
    }

    protected Stream<String> generateRaw(SchematicInput<SENDER> schematicInput) {
        CommandExecutor<SENDER> executor = schematicInput.getExecutor();
        String base = schematicInput.collectRoutes().stream().map(route -> route.getName()).collect(Collectors.joining(SEPARATOR)) + SEPARATOR;
        Stream<String> routeScheme = this.generateRoute(schematicInput, schematicInput.getLastRoute(), base);
        if (executor != null && this.isVisible(schematicInput, executor)) {
            Stream<String> executorScheme = Stream.of(base + this.generateExecutor(schematicInput, executor));
            return Stream.concat(routeScheme, executorScheme);
        }
        return routeScheme;
    }

    protected Stream<String> generateRoute(SchematicInput<SENDER> input, CommandRoute<SENDER> route, String base) {
        Stream children = route.getChildren().stream().flatMap(subRoute -> this.generateRoute(input, (CommandRoute<SENDER>)subRoute, base + subRoute.getName() + SEPARATOR));
        Stream<String> executors = route.getExecutors().stream().filter(executor -> this.isVisible(input, (CommandExecutor<SENDER>)executor)).map(executor -> base + this.generateExecutor(input, (CommandExecutor<SENDER>)executor));
        return Stream.concat(executors, children);
    }

    protected String generateExecutor(SchematicInput<SENDER> input, CommandExecutor<SENDER> executor) {
        return executor.getArguments().stream().map(argument -> String.format(this.generateArgumentFormat(input, (Argument<?>)argument), this.generateArgumentName(input, (Argument<?>)argument))).collect(Collectors.joining(SEPARATOR));
    }

    protected String generateArgumentFormat(SchematicInput<SENDER> input, Argument<?> argument) {
        return this.isOptional(input, argument) ? this.format.optionalArgumentFormat() : this.format.argumentFormat();
    }

    protected String generateArgumentName(SchematicInput<SENDER> input, Argument<?> argument) {
        return argument.getName();
    }

    protected boolean isVisible(SchematicInput<SENDER> input, CommandExecutor<SENDER> executor) {
        return this.permissionService.validate(input.getInvocation().platformSender(), executor).isPermitted();
    }

    protected <T> boolean isOptional(SchematicInput<SENDER> input, Argument<T> argument) {
        Range range;
        Parser<SENDER, T> parser = this.parserRegistry.getParserOrNull(argument);
        if (parser != null && (range = parser.getRange(argument)).getMin() == 0) {
            return true;
        }
        return argument.hasDefaultValue();
    }
}

