/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.meta;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.type.TypeToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface MetaType<T> {
    public T cast(Object var1);

    default public T in(T value) {
        return value;
    }

    default public T out(T value) {
        return value;
    }

    public static <E> MetaType<List<E>> list() {
        return new MetaTypeList();
    }

    public static <E> MetaType<Set<E>> set() {
        return new MetaTypeSet();
    }

    public static <T> MetaType<T> of(Class<T> type) {
        return new MetaTypeImpl<T>(TypeToken.of(type));
    }

    public static <T> MetaType<T> of(TypeToken<T> type) {
        return new MetaTypeImpl<T>(type);
    }

    public static class MetaTypeSet<T>
    implements MetaType<Set<T>> {
        @Override
        public Set<T> cast(Object value) {
            return (Set)value;
        }

        @Override
        public Set<T> in(Set<T> value) {
            return new HashSet<T>(value);
        }

        @Override
        public Set<T> out(Set<T> value) {
            return new HashSet<T>(value);
        }

        public String toString() {
            return "Set<T>";
        }
    }

    public static class MetaTypeList<T>
    implements MetaType<List<T>> {
        @Override
        public List<T> cast(Object value) {
            return (List)value;
        }

        @Override
        public List<T> in(List<T> value) {
            return new ArrayList<T>(value);
        }

        @Override
        public List<T> out(List<T> value) {
            return new ArrayList<T>(value);
        }

        public String toString() {
            return "List<T>";
        }
    }

    public static class MetaTypeImpl<T>
    implements MetaType<T> {
        private final TypeToken<T> type;

        public MetaTypeImpl(TypeToken<T> type) {
            this.type = type;
        }

        @Override
        public T cast(Object value) {
            return this.type.getRawType().cast(value);
        }

        public String toString() {
            return this.type.getRawType().getTypeName();
        }
    }
}

