/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.notification;

import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.libs.com.eternalcode.multification.adventure.AudienceConverter;
import com.eternalcode.combat.libs.com.eternalcode.multification.bukkit.BukkitMultification;
import com.eternalcode.combat.libs.com.eternalcode.multification.translation.TranslationProvider;
import com.eternalcode.combat.libs.net.kyori.adventure.platform.AudienceProvider;
import com.eternalcode.combat.libs.net.kyori.adventure.text.Component;
import com.eternalcode.combat.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.combat.libs.net.kyori.adventure.text.serializer.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class NoticeService
extends BukkitMultification<PluginConfig> {
    private final AudienceProvider audienceProvider;
    private final PluginConfig pluginConfig;
    private final MiniMessage miniMessage;

    public NoticeService(AudienceProvider audienceProvider, PluginConfig pluginConfig, MiniMessage miniMessage) {
        this.audienceProvider = audienceProvider;
        this.pluginConfig = pluginConfig;
        this.miniMessage = miniMessage;
    }

    @Override
    @NotNull
    protected TranslationProvider<PluginConfig> translationProvider() {
        return locale -> this.pluginConfig;
    }

    @Override
    @NotNull
    protected ComponentSerializer<Component, Component, String> serializer() {
        return this.miniMessage;
    }

    @Override
    @NotNull
    protected AudienceConverter<CommandSender> audienceConverter() {
        return commandSender -> {
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                return this.audienceProvider.player(player.getUniqueId());
            }
            return this.audienceProvider.console();
        };
    }
}

