/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.transformer;

import com.eternalcode.combat.libs.eu.okaeri.configs.exception.OkaeriException;
import com.eternalcode.combat.libs.eu.okaeri.configs.schema.GenericsPair;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.BidirectionalTransformer;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.SerdesContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.enchantments.Enchantment;

public class StringEnchantmentTransformer
extends BidirectionalTransformer<String, Enchantment> {
    private static Map<String, Enchantment> byName = new HashMap<String, Enchantment>();

    @Override
    public GenericsPair<String, Enchantment> getPair() {
        return this.genericsPair(String.class, Enchantment.class);
    }

    @Override
    public Enchantment leftToRight(@NonNull String data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        Enchantment enchantment = Enchantment.getByName((String)data);
        if (enchantment == null) {
            if (byName.isEmpty()) {
                for (Enchantment e : Enchantment.values()) {
                    byName.put(e.getName().toUpperCase(Locale.ROOT), e);
                }
            }
            enchantment = byName.get(data.toUpperCase(Locale.ROOT));
        }
        if (enchantment == null) {
            String available = Arrays.stream(Enchantment.values()).map(Enchantment::getName).collect(Collectors.joining(", "));
            throw new OkaeriException("Unknown enchantment: " + data + " (Available: " + available);
        }
        return enchantment;
    }

    @Override
    public String rightToLeft(@NonNull Enchantment data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        return data.getName();
    }
}

