/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.eu.okaeri.configs.serdes.commons.duration;

import com.eternalcode.combat.libs.eu.okaeri.configs.schema.GenericsPair;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.BidirectionalTransformer;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.SerdesContext;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.commons.duration.DurationFormat;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.commons.duration.DurationSpecData;
import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class DurationTransformer
extends BidirectionalTransformer<String, Duration> {
    private static final Pattern SIMPLE_ISO_DURATION_PATTERN = Pattern.compile("PT(?<value>-?[0-9]+)(?<unit>H|M|S)");
    private static final Pattern SUBSEC_ISO_DURATION_PATTERN = Pattern.compile("PT(?<value>-?[0-9]\\.[0-9]+)S?");
    private static final Pattern SIMPLE_DURATION_PATTERN = Pattern.compile("(?<value>-?[0-9]+)(?<unit>ms|ns|d|h|m|s)");
    private static final Pattern JBOD_FULL_DURATION_PATTERN = Pattern.compile("((-?[0-9]+)(ms|ns|d|h|m|s))+");

    private static Duration timeToDuration(long longValue, String unit) {
        switch (unit) {
            case "d": {
                return Duration.ofDays(longValue);
            }
            case "h": {
                return Duration.ofHours(longValue);
            }
            case "m": {
                return Duration.ofMinutes(longValue);
            }
            case "s": {
                return Duration.ofSeconds(longValue);
            }
            case "ms": {
                return Duration.ofMillis(longValue);
            }
            case "ns": {
                return Duration.ofNanos(longValue);
            }
        }
        throw new IllegalArgumentException("Really, this one should not be possible: " + unit);
    }

    private static Optional<Duration> readJbodPattern(String text) {
        text = text.toLowerCase(Locale.ROOT);
        Matcher fullMatcher = JBOD_FULL_DURATION_PATTERN.matcher(text = text.replace(" ", ""));
        if (!fullMatcher.matches()) {
            return Optional.empty();
        }
        Matcher matcher = SIMPLE_DURATION_PATTERN.matcher(text);
        boolean matched = false;
        BigInteger currentValue = BigInteger.valueOf(0L);
        while (matcher.find()) {
            matched = true;
            long longValue = Long.parseLong(matcher.group("value"));
            String unit = matcher.group("unit");
            currentValue = currentValue.add(BigInteger.valueOf(DurationTransformer.timeToDuration(longValue, unit).toNanos()));
        }
        return matched ? Optional.of(Duration.ofNanos(currentValue.longValueExact())) : Optional.empty();
    }

    @Override
    public GenericsPair<String, Duration> getPair() {
        return this.genericsPair(String.class, Duration.class);
    }

    @Override
    public Duration leftToRight(@NonNull String data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        Optional<Duration> jbodResult = DurationTransformer.readJbodPattern(data);
        if (jbodResult.isPresent()) {
            return jbodResult.get();
        }
        if (data.matches("-?\\d+")) {
            long longValue = Long.parseLong(data);
            TemporalUnit unit = serdesContext.getAttachment(DurationSpecData.class).map(DurationSpecData::getFallbackUnit).orElse(ChronoUnit.SECONDS);
            return Duration.of(longValue, unit);
        }
        return Duration.parse(data);
    }

    @Override
    public String rightToLeft(@NonNull Duration data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        DurationFormat durationFormat = serdesContext.getAttachment(DurationSpecData.class).map(DurationSpecData::getFormat).orElse(DurationFormat.SIMPLIFIED);
        TemporalUnit fallbackUnit = serdesContext.getAttachment(DurationSpecData.class).map(DurationSpecData::getFallbackUnit).orElse(ChronoUnit.SECONDS);
        if (durationFormat == DurationFormat.ISO) {
            return data.toString();
        }
        if (data.isZero()) {
            return "0";
        }
        String stringDuration = data.toString();
        Matcher matcher = SIMPLE_ISO_DURATION_PATTERN.matcher(stringDuration);
        if (matcher.matches()) {
            long longValue = Long.parseLong(matcher.group("value"));
            String unit = matcher.group("unit").toLowerCase(Locale.ROOT);
            if ("h".equals(unit) && longValue % 24L == 0L && fallbackUnit != ChronoUnit.HOURS) {
                return (longValue < 0L ? "-" : "") + longValue / 24L + "d";
            }
            return (longValue < 0L ? "-" : "") + longValue + unit;
        }
        Matcher subsecMatcher = SUBSEC_ISO_DURATION_PATTERN.matcher(stringDuration);
        if (subsecMatcher.matches()) {
            double doubleValue = Double.parseDouble(subsecMatcher.group("value"));
            boolean negative = doubleValue < 0.0;
            double absoluteValue = Math.abs(doubleValue);
            int msValue = (int)Math.round(absoluteValue * 1000.0);
            if (msValue > 0) {
                return (negative ? "-" : "") + msValue + "ms";
            }
            int nsValue = (int)Math.ceil(absoluteValue * 1.0E9);
            return (negative ? "-" : "") + nsValue + "ns";
        }
        String simplified = stringDuration.substring(2).toLowerCase(Locale.ROOT);
        try {
            if (data.equals(this.leftToRight(simplified, serdesContext))) {
                return simplified;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringDuration;
    }
}

